/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.resource.ResourceUtil;
import com.ccb.core.lang.Assert;
import com.ccb.core.net.URLDecoder;
import com.ccb.core.net.URLEncoder;
import com.ccb.core.net.url.UrlQuery;
import com.ccb.core.util.CharUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ClassLoaderUtil;
import com.ccb.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.JarFile;

public class URLUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    public static URL url(String string) {
        return URLUtil.url(string, null);
    }

    public static URL url(String string, URLStreamHandler uRLStreamHandler) {
        Assert.notNull(string, "URL must not be null", new Object[0]);
        if (string.startsWith(CLASSPATH_URL_PREFIX)) {
            string = string.substring(CLASSPATH_URL_PREFIX.length());
            return ClassLoaderUtil.getClassLoader().getResource(string);
        }
        try {
            return new URL(null, string, uRLStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                throw new UtilException(malformedURLException);
            }
        }
    }

    public static URL toUrlForHttp(String string) {
        return URLUtil.toUrlForHttp(string, null);
    }

    public static URL toUrlForHttp(String string, URLStreamHandler uRLStreamHandler) {
        Assert.notBlank(string, "Url is blank !", new Object[0]);
        string = URLUtil.encodeBlank(string);
        try {
            return new URL(null, string, uRLStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UtilException(malformedURLException);
        }
    }

    public static String encodeBlank(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (CharUtil.isBlankChar(c2)) {
                stringBuilder.append("%20");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static URL getURL(String string) {
        return ResourceUtil.getResource(string);
    }

    public static URL getURL(String string, Class clazz) {
        return ResourceUtil.getResource(string, clazz);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new UtilException(malformedURLException, "Error occured when get URL!", new Object[0]);
        }
    }

    public static URL[] getURLs(File ... fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        try {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                uRLArray[i2] = fileArray[i2].toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new UtilException(malformedURLException, "Error occured when get URL!", new Object[0]);
        }
        return uRLArray;
    }

    public static URI getHost(URL uRL) {
        if (null == uRL) {
            return null;
        }
        try {
            return new URI(uRL.getProtocol(), uRL.getHost(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UtilException(uRISyntaxException);
        }
    }

    public static String complateUrl(String string, String string2) {
        return URLUtil.completeUrl(string, string2);
    }

    public static String completeUrl(String string, String string2) {
        if (StrUtil.isBlank(string = URLUtil.normalize(string, false))) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(uRL, string2);
            return uRL2.toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new UtilException(malformedURLException);
        }
    }

    public static String encodeAll(String string) {
        return URLUtil.encodeAll(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeAll(String string, Charset charset) {
        if (null == charset) {
            return string;
        }
        return URLEncoder.ALL.encode(string, charset);
    }

    public static String encode(String string) {
        return URLUtil.encode(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeQuery(String string) {
        return URLUtil.encodeQuery(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encode(String string, Charset charset) {
        if (StrUtil.isEmpty(string)) {
            return string;
        }
        if (null == charset) {
            charset = CharsetUtil.defaultCharset();
        }
        return URLEncoder.DEFAULT.encode(string, charset);
    }

    public static String encodeQuery(String string, Charset charset) {
        if (StrUtil.isEmpty(string)) {
            return string;
        }
        if (null == charset) {
            charset = CharsetUtil.defaultCharset();
        }
        return URLEncoder.QUERY.encode(string, charset);
    }

    public static String encode(String string, String string2) {
        if (StrUtil.isEmpty(string)) {
            return string;
        }
        return URLUtil.encode(string, StrUtil.isBlank(string2) ? CharsetUtil.defaultCharset() : CharsetUtil.charset(string2));
    }

    public static String encodeQuery(String string, String string2) {
        return URLUtil.encodeQuery(string, StrUtil.isBlank(string2) ? CharsetUtil.defaultCharset() : CharsetUtil.charset(string2));
    }

    public static String decode(String string) {
        return URLUtil.decode(string, "UTF-8");
    }

    public static String decode(String string, Charset charset) {
        if (null == charset) {
            return string;
        }
        return URLDecoder.decode(string, charset);
    }

    public static String decode(String string, String string2) {
        return URLUtil.decode(string, CharsetUtil.charset(string2));
    }

    public static String getPath(String string) {
        return URLUtil.toURI(string).getPath();
    }

    public static String getDecodedPath(URL uRL) {
        if (null == uRL) {
            return null;
        }
        String string = null;
        try {
            string = URLUtil.toURI(uRL).getPath();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        return null != string ? string : uRL.getPath();
    }

    public static URI toURI(URL uRL) {
        return URLUtil.toURI(uRL, false);
    }

    public static URI toURI(URL uRL, boolean bl) {
        if (null == uRL) {
            return null;
        }
        return URLUtil.toURI(uRL.toString(), bl);
    }

    public static URI toURI(String string) {
        return URLUtil.toURI(string, false);
    }

    public static URI toURI(String string, boolean bl) {
        if (bl) {
            string = URLUtil.encode(string);
        }
        try {
            return new URI(StrUtil.trim(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UtilException(uRISyntaxException);
        }
    }

    public static boolean isFileURL(URL uRL) {
        String string = uRL.getProtocol();
        return URL_PROTOCOL_FILE.equals(string) || URL_PROTOCOL_VFSFILE.equals(string) || URL_PROTOCOL_VFS.equals(string);
    }

    public static boolean isJarURL(URL uRL) {
        String string = uRL.getProtocol();
        return URL_PROTOCOL_JAR.equals(string) || URL_PROTOCOL_ZIP.equals(string) || URL_PROTOCOL_VFSZIP.equals(string) || URL_PROTOCOL_WSJAR.equals(string);
    }

    public static boolean isJarFileURL(URL uRL) {
        return URL_PROTOCOL_FILE.equals(uRL.getProtocol()) && uRL.getPath().toLowerCase().endsWith(".jar");
    }

    public static InputStream getStream(URL uRL) {
        Assert.notNull(uRL);
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static BufferedReader getReader(URL uRL, Charset charset) {
        return IoUtil.getReader(URLUtil.getStream(uRL), charset);
    }

    public static JarFile getJarFile(URL uRL) {
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            return jarURLConnection.getJarFile();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static String normalize(String string) {
        return URLUtil.normalize(string, false);
    }

    public static String normalize(String string, boolean bl) {
        String string2;
        String string3;
        if (StrUtil.isBlank(string)) {
            return string;
        }
        int n2 = string.indexOf("://");
        if (n2 > 0) {
            string3 = StrUtil.subPre(string, n2 + 3);
            string2 = StrUtil.subSuf(string, n2 + 3);
        } else {
            string3 = "http://";
            string2 = string;
        }
        int n3 = StrUtil.indexOf(string2, '?');
        String string4 = null;
        if (n3 > 0) {
            string4 = StrUtil.subSuf(string2, n3);
            string2 = StrUtil.subPre(string2, n3);
        }
        if (StrUtil.isNotEmpty(string2)) {
            string2 = string2.replaceAll("^[\\\\/]+", "");
            string2 = string2.replace("\\", "/").replaceAll("//+", "/");
        }
        int n4 = StrUtil.indexOf(string2, '/');
        String string5 = string2;
        String string6 = null;
        if (n4 > 0) {
            string5 = StrUtil.subPre(string2, n4);
            string6 = StrUtil.subSuf(string2, n4);
        }
        if (bl) {
            string6 = URLUtil.encode(string6);
        }
        return string3 + string5 + StrUtil.nullToEmpty(string6) + StrUtil.nullToEmpty(string4);
    }

    public static String buildQuery(Map map, Charset charset) {
        return UrlQuery.of(map).build(charset);
    }

    public static long getContentLength(URL uRL) {
        if (null == uRL) {
            return -1L;
        }
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
            long l2 = uRLConnection.getContentLengthLong();
            return l2;
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
    }

    public static String getDataUriBase64(String string, String string2) {
        return URLUtil.getDataUri(string, null, "BASE64", string2);
    }

    public static String getDataUri(String string, String string2, String string3) {
        return URLUtil.getDataUri(string, null, string2, string3);
    }

    public static String getDataUri(String string, Charset charset, String string2, String string3) {
        StringBuilder stringBuilder = StrUtil.builder("data:");
        if (StrUtil.isNotBlank(string)) {
            stringBuilder.append(string);
        }
        if (null != charset) {
            stringBuilder.append(";charset=").append(charset.name());
        }
        if (StrUtil.isNotBlank(string2)) {
            stringBuilder.append(';').append(string2);
        }
        stringBuilder.append(',').append(string3);
        return stringBuilder.toString();
    }
}

