/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.lang.ParameterizedTypeImpl;
import com.ccb.core.lang.reflect.ActualTypeMapperPool;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;

public class TypeUtil {
    public static Class getClass(Type type) {
        if (null != type) {
            Type[] typeArray;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                return (Class)((TypeVariable)type).getBounds()[0];
            }
            if (type instanceof WildcardType && (typeArray = ((WildcardType)type).getUpperBounds()).length == 1) {
                return TypeUtil.getClass(typeArray[0]);
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Type getFieldType(Class clazz, String string) {
        return TypeUtil.getType(ReflectUtil.getField(clazz, string));
    }

    public static Class getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getFirstParamType(Method method) {
        return TypeUtil.getParamType(method, 0);
    }

    public static Class getFirstParamClass(Method method) {
        return TypeUtil.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int n2) {
        Type[] typeArray = TypeUtil.getParamTypes(method);
        if (null != typeArray && typeArray.length > n2) {
            return typeArray[n2];
        }
        return null;
    }

    public static Class getParamClass(Method method, int n2) {
        Class[] classArray = TypeUtil.getParamClasses(method);
        if (null != classArray && classArray.length > n2) {
            return classArray[n2];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtil.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int n2) {
        Type[] typeArray = TypeUtil.getTypeArguments(type);
        if (null != typeArray && typeArray.length > n2) {
            return typeArray[n2];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtil.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType parameterizedType = null;
        if (type instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Object[] objectArray;
            Class clazz = (Class)type;
            Object object = clazz.getGenericSuperclass();
            if ((null == object || Object.class.equals(object)) && ArrayUtil.isNotEmpty(objectArray = clazz.getGenericInterfaces())) {
                object = objectArray[0];
            }
            parameterizedType = TypeUtil.toParameterizedType((Type)object);
        }
        return parameterizedType;
    }

    public static boolean isUnknown(Type type) {
        return null == type || type instanceof TypeVariable;
    }

    public static boolean hasTypeVeriable(Type ... typeArray) {
        for (Type type : typeArray) {
            if (!(type instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    public static Map getTypeMap(Class clazz) {
        return ActualTypeMapperPool.get(clazz);
    }

    public static Type getActualType(Type type, Field field) {
        if (null == field) {
            return null;
        }
        return TypeUtil.getActualType((Type)ObjectUtil.defaultIfNull(type, field.getDeclaringClass()), field.getGenericType());
    }

    public static Type getActualType(Type type, Type type2) {
        if (type2 instanceof ParameterizedType) {
            return TypeUtil.getActualType(type, (ParameterizedType)type2);
        }
        if (type2 instanceof TypeVariable) {
            return ActualTypeMapperPool.getActualType(type, (TypeVariable)type2);
        }
        return type2;
    }

    public static Type getActualType(Type type, ParameterizedType parameterizedType) {
        Object[] objectArray = parameterizedType.getActualTypeArguments();
        if (TypeUtil.hasTypeVeriable((Type[])objectArray) && ArrayUtil.isNotEmpty(objectArray = TypeUtil.getActualTypes(type, parameterizedType.getActualTypeArguments()))) {
            parameterizedType = new ParameterizedTypeImpl((Type[])objectArray, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        return parameterizedType;
    }

    public static Type[] getActualTypes(Type type, Type ... typeArray) {
        return ActualTypeMapperPool.getActualTypes(type, typeArray);
    }
}

