/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.lang.PatternPool;
import com.ccb.core.lang.Validator;
import com.ccb.core.util.StrUtil;
import java.util.regex.Pattern;

public class PhoneUtil {
    private static final Pattern TEL = Pattern.compile("0\\d{2,3}-[1-9]\\d{6,7}");

    public static boolean isMobile(CharSequence charSequence) {
        return Validator.isMatchRegex(PatternPool.MOBILE, charSequence);
    }

    public static boolean isTel(CharSequence charSequence) {
        return Validator.isMatchRegex(TEL, charSequence);
    }

    public static boolean isPhone(CharSequence charSequence) {
        return PhoneUtil.isMobile(charSequence) || PhoneUtil.isTel(charSequence);
    }

    public static CharSequence hideBefore(CharSequence charSequence) {
        return StrUtil.hide(charSequence, 0, 7);
    }

    public static CharSequence hideBetween(CharSequence charSequence) {
        return StrUtil.hide(charSequence, 3, 7);
    }

    public static CharSequence hideAfter(CharSequence charSequence) {
        return StrUtil.hide(charSequence, 7, 11);
    }

    public static CharSequence subBefore(CharSequence charSequence) {
        return StrUtil.sub(charSequence, 0, 3);
    }

    public static CharSequence subBetween(CharSequence charSequence) {
        return StrUtil.sub(charSequence, 3, 7);
    }

    public static CharSequence subAfter(CharSequence charSequence) {
        return StrUtil.sub(charSequence, 7, 11);
    }
}

