/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.date.DatePattern;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.DateUtil;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.PatternPool;
import com.ccb.core.lang.Validator;
import com.ccb.core.util.IdcardUtil$Idcard;
import com.ccb.core.util.ReUtil;
import com.ccb.core.util.StrUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class IdcardUtil {
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final Map CITY_CODES = new HashMap();
    private static final Map TW_FIRST_CODE = new HashMap();

    public static String convert15To18(String string) {
        int n2;
        if (string.length() != 15) {
            return null;
        }
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)string)) {
            String string2 = string.substring(6, 12);
            DateTime dateTime = DateUtil.parse((CharSequence)string2, "yyMMdd");
            n2 = DateUtil.year(dateTime);
            if (n2 > 2000) {
                n2 -= 100;
            }
        } else {
            return null;
        }
        StringBuilder stringBuilder = StrUtil.builder().append(string, 0, 6).append(n2).append(string.substring(8));
        char c2 = IdcardUtil.getCheckCode18(stringBuilder.toString());
        stringBuilder.append(c2);
        return stringBuilder.toString();
    }

    public static boolean isValidCard(String string) {
        string = string.trim();
        int n2 = string.length();
        switch (n2) {
            case 18: {
                return IdcardUtil.isValidCard18(string);
            }
            case 15: {
                return IdcardUtil.isValidCard15(string);
            }
            case 10: {
                String[] stringArray = IdcardUtil.isValidCard10(string);
                return null != stringArray && "true".equals(stringArray[2]);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String string) {
        if (18 != string.length()) {
            return false;
        }
        String string2 = string.substring(0, 2);
        if (null == CITY_CODES.get(string2)) {
            return false;
        }
        if (!Validator.isBirthday(string.substring(6, 14))) {
            return false;
        }
        String string3 = string.substring(0, 17);
        char c2 = Character.toLowerCase(string.charAt(17));
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)string3)) {
            char c3 = IdcardUtil.getCheckCode18(string3);
            return c3 == c2;
        }
        return false;
    }

    public static boolean isValidCard15(String string) {
        if (15 != string.length()) {
            return false;
        }
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)string)) {
            String string2 = string.substring(0, 2);
            if (null == CITY_CODES.get(string2)) {
                return false;
            }
            return false != Validator.isBirthday("19" + string.substring(6, 12));
        }
        return false;
    }

    public static String[] isValidCard10(String string) {
        if (StrUtil.isBlank(string)) {
            return null;
        }
        String[] stringArray = new String[3];
        String string2 = string.replaceAll("[()]", "");
        if (string2.length() != 8 && string2.length() != 9 && string.length() != 10) {
            return null;
        }
        if (string.matches("^[a-zA-Z][0-9]{9}$")) {
            stringArray[0] = "\u53f0\u6e7e";
            char c2 = string.charAt(1);
            if ('1' == c2) {
                stringArray[1] = "M";
            } else if ('2' == c2) {
                stringArray[1] = "F";
            } else {
                stringArray[1] = "N";
                stringArray[2] = "false";
                return stringArray;
            }
            stringArray[2] = IdcardUtil.isValidTWCard(string) ? "true" : "false";
        } else if (string.matches("^[157][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            stringArray[0] = "\u6fb3\u95e8";
            stringArray[1] = "N";
        } else if (string.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            stringArray[0] = "\u9999\u6e2f";
            stringArray[1] = "N";
            stringArray[2] = IdcardUtil.isValidHKCard(string) ? "true" : "false";
        } else {
            return null;
        }
        return stringArray;
    }

    public static boolean isValidTWCard(String string) {
        if (StrUtil.isEmpty(string)) {
            return false;
        }
        String string2 = string.substring(0, 1);
        Integer n2 = (Integer)TW_FIRST_CODE.get(string2);
        if (null == n2) {
            return false;
        }
        String string3 = string.substring(1, 9);
        String string4 = string.substring(9, 10);
        int n3 = n2 / 10 + n2 % 10 * 9;
        char[] cArray = string3.toCharArray();
        int n4 = 8;
        for (char c2 : cArray) {
            n3 += Integer.parseInt(String.valueOf(c2)) * n4;
            --n4;
        }
        return (n3 % 10 == 0 ? 0 : 10 - n3 % 10) == Integer.parseInt(string4);
    }

    public static boolean isValidHKCard(String string) {
        int n2;
        String string2 = string.replaceAll("[()]", "");
        if (string2.length() == 9) {
            n2 = (Character.toUpperCase(string2.charAt(0)) - 55) * 9 + (Character.toUpperCase(string2.charAt(1)) - 55) * 8;
            string2 = string2.substring(1, 9);
        } else {
            n2 = 522 + (Character.toUpperCase(string2.charAt(0)) - 55) * 8;
        }
        char c2 = string.charAt(0);
        int n3 = c2 - 65 + 1;
        String string3 = string2.substring(1, 7);
        String string4 = string2.substring(7, 8);
        char[] cArray = string3.toCharArray();
        int n4 = 7;
        for (char c3 : cArray) {
            n2 += Integer.parseInt(String.valueOf(c3)) * n4;
            --n4;
        }
        n2 = "A".equals(string4.toUpperCase()) ? (n2 += 10) : (n2 += Integer.parseInt(string4));
        return n2 % 11 == 0;
    }

    public static String getBirthByIdCard(String string) {
        return IdcardUtil.getBirth(string);
    }

    public static String getBirth(String string) {
        Assert.notBlank(string, "id card must be not blank!", new Object[0]);
        int n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtil.convert15To18(string);
        }
        return Objects.requireNonNull(string).substring(6, 14);
    }

    public static DateTime getBirthDate(String string) {
        String string2 = IdcardUtil.getBirthByIdCard(string);
        return null == string2 ? null : DateUtil.parse((CharSequence)string2, DatePattern.PURE_DATE_FORMAT);
    }

    public static int getAgeByIdCard(String string) {
        return IdcardUtil.getAgeByIdCard(string, DateUtil.date());
    }

    public static int getAgeByIdCard(String string, Date date) {
        String string2 = IdcardUtil.getBirthByIdCard(string);
        return DateUtil.age(DateUtil.parse((CharSequence)string2, "yyyyMMdd"), date);
    }

    public static Short getYearByIdCard(String string) {
        int n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtil.convert15To18(string);
        }
        return Short.valueOf(Objects.requireNonNull(string).substring(6, 10));
    }

    public static Short getMonthByIdCard(String string) {
        int n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtil.convert15To18(string);
        }
        return Short.valueOf(Objects.requireNonNull(string).substring(10, 12));
    }

    public static Short getDayByIdCard(String string) {
        int n2 = string.length();
        if (n2 < 15) {
            return null;
        }
        if (n2 == 15) {
            string = IdcardUtil.convert15To18(string);
        }
        return Short.valueOf(Objects.requireNonNull(string).substring(12, 14));
    }

    public static int getGenderByIdCard(String string) {
        char c2;
        Assert.notBlank(string);
        int n2 = string.length();
        if (n2 < 15) {
            throw new IllegalArgumentException("ID Card length must be 15 or 18");
        }
        if (n2 == 15) {
            string = IdcardUtil.convert15To18(string);
        }
        return (c2 = Objects.requireNonNull(string).charAt(16)) % 2 != 0 ? 1 : 0;
    }

    public static String getProvinceByIdCard(String string) {
        int n2 = string.length();
        if (n2 == 15 || n2 == 18) {
            String string2 = string.substring(0, 2);
            return (String)CITY_CODES.get(string2);
        }
        return null;
    }

    public static String getCityCodeByIdCard(String string) {
        int n2 = string.length();
        if (n2 == 15 || n2 == 18) {
            return string.substring(0, 5);
        }
        return null;
    }

    public static String hide(String string, int n2, int n3) {
        return StrUtil.hide(string, n2, n3);
    }

    public static IdcardUtil$Idcard getIdcardInfo(String string) {
        return new IdcardUtil$Idcard(string);
    }

    private static char getCheckCode18(String string) {
        int n2 = IdcardUtil.getPowerSum(string.toCharArray());
        return IdcardUtil.getCheckCode18(n2);
    }

    private static char getCheckCode18(int n2) {
        switch (n2 % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'x';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static int getPowerSum(char[] cArray) {
        int n2 = 0;
        if (POWER.length == cArray.length) {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                n2 += Integer.parseInt(String.valueOf(cArray[i2])) * POWER[i2];
            }
        }
        return n2;
    }

    static /* synthetic */ Map access$000() {
        return CITY_CODES;
    }

    static {
        CITY_CODES.put("11", "\u5317\u4eac");
        CITY_CODES.put("12", "\u5929\u6d25");
        CITY_CODES.put("13", "\u6cb3\u5317");
        CITY_CODES.put("14", "\u5c71\u897f");
        CITY_CODES.put("15", "\u5185\u8499\u53e4");
        CITY_CODES.put("21", "\u8fbd\u5b81");
        CITY_CODES.put("22", "\u5409\u6797");
        CITY_CODES.put("23", "\u9ed1\u9f99\u6c5f");
        CITY_CODES.put("31", "\u4e0a\u6d77");
        CITY_CODES.put("32", "\u6c5f\u82cf");
        CITY_CODES.put("33", "\u6d59\u6c5f");
        CITY_CODES.put("34", "\u5b89\u5fbd");
        CITY_CODES.put("35", "\u798f\u5efa");
        CITY_CODES.put("36", "\u6c5f\u897f");
        CITY_CODES.put("37", "\u5c71\u4e1c");
        CITY_CODES.put("41", "\u6cb3\u5357");
        CITY_CODES.put("42", "\u6e56\u5317");
        CITY_CODES.put("43", "\u6e56\u5357");
        CITY_CODES.put("44", "\u5e7f\u4e1c");
        CITY_CODES.put("45", "\u5e7f\u897f");
        CITY_CODES.put("46", "\u6d77\u5357");
        CITY_CODES.put("50", "\u91cd\u5e86");
        CITY_CODES.put("51", "\u56db\u5ddd");
        CITY_CODES.put("52", "\u8d35\u5dde");
        CITY_CODES.put("53", "\u4e91\u5357");
        CITY_CODES.put("54", "\u897f\u85cf");
        CITY_CODES.put("61", "\u9655\u897f");
        CITY_CODES.put("62", "\u7518\u8083");
        CITY_CODES.put("63", "\u9752\u6d77");
        CITY_CODES.put("64", "\u5b81\u590f");
        CITY_CODES.put("65", "\u65b0\u7586");
        CITY_CODES.put("71", "\u53f0\u6e7e");
        CITY_CODES.put("81", "\u9999\u6e2f");
        CITY_CODES.put("82", "\u6fb3\u95e8");
        CITY_CODES.put("91", "\u56fd\u5916");
        TW_FIRST_CODE.put("A", 10);
        TW_FIRST_CODE.put("B", 11);
        TW_FIRST_CODE.put("C", 12);
        TW_FIRST_CODE.put("D", 13);
        TW_FIRST_CODE.put("E", 14);
        TW_FIRST_CODE.put("F", 15);
        TW_FIRST_CODE.put("G", 16);
        TW_FIRST_CODE.put("H", 17);
        TW_FIRST_CODE.put("J", 18);
        TW_FIRST_CODE.put("K", 19);
        TW_FIRST_CODE.put("L", 20);
        TW_FIRST_CODE.put("M", 21);
        TW_FIRST_CODE.put("N", 22);
        TW_FIRST_CODE.put("P", 23);
        TW_FIRST_CODE.put("Q", 24);
        TW_FIRST_CODE.put("R", 25);
        TW_FIRST_CODE.put("S", 26);
        TW_FIRST_CODE.put("T", 27);
        TW_FIRST_CODE.put("U", 28);
        TW_FIRST_CODE.put("V", 29);
        TW_FIRST_CODE.put("X", 30);
        TW_FIRST_CODE.put("Y", 31);
        TW_FIRST_CODE.put("W", 32);
        TW_FIRST_CODE.put("Z", 33);
        TW_FIRST_CODE.put("I", 34);
        TW_FIRST_CODE.put("O", 35);
    }
}

