/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.convert.BasicType;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.resource.ResourceUtil;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.ClassScanner;
import com.ccb.core.lang.Filter;
import com.ccb.core.lang.Singleton;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ClassLoaderUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.TypeUtil;
import com.ccb.core.util.URLUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ClassUtil {
    public static Class getClass(Object object) {
        return null == object ? null : object.getClass();
    }

    public static Class getEnclosingClass(Class clazz) {
        return null == clazz ? null : clazz.getEnclosingClass();
    }

    public static boolean isTopLevelClass(Class clazz) {
        if (null == clazz) {
            return false;
        }
        return null == ClassUtil.getEnclosingClass(clazz);
    }

    public static String getClassName(Object object, boolean bl) {
        if (null == object) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return ClassUtil.getClassName(clazz, bl);
    }

    public static String getClassName(Class clazz, boolean bl) {
        if (null == clazz) {
            return null;
        }
        return bl ? clazz.getSimpleName() : clazz.getName();
    }

    public static String getShortClassName(String string) {
        List list = StrUtil.split((CharSequence)string, '.');
        if (null == list || list.size() < 2) {
            return string;
        }
        int n2 = list.size();
        StringBuilder stringBuilder = StrUtil.builder();
        stringBuilder.append(((String)list.get(0)).charAt(0));
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            stringBuilder.append('.').append(((String)list.get(i2)).charAt(0));
        }
        stringBuilder.append('.').append((String)list.get(n2 - 1));
        return stringBuilder.toString();
    }

    public static Class[] getClasses(Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            classArray[i2] = null == object ? Object.class : object.getClass();
        }
        return classArray;
    }

    public static boolean equals(Class clazz, String string, boolean bl) {
        if (null == clazz || StrUtil.isBlank(string)) {
            return false;
        }
        if (bl) {
            return string.equalsIgnoreCase(clazz.getName()) || string.equalsIgnoreCase(clazz.getSimpleName());
        }
        return string.equals(clazz.getName()) || string.equals(clazz.getSimpleName());
    }

    public static Set scanPackageByAnnotation(String string, Class clazz) {
        return ClassScanner.scanPackageByAnnotation(string, clazz);
    }

    public static Set scanPackageBySuper(String string, Class clazz) {
        return ClassScanner.scanPackageBySuper(string, clazz);
    }

    public static Set scanPackage() {
        return ClassScanner.scanPackage();
    }

    public static Set scanPackage(String string) {
        return ClassScanner.scanPackage(string);
    }

    public static Set scanPackage(String string, Filter filter) {
        return ClassScanner.scanPackage(string, filter);
    }

    public static Set getPublicMethodNames(Class clazz) {
        return ReflectUtil.getPublicMethodNames(clazz);
    }

    public static Method[] getPublicMethods(Class clazz) {
        return ReflectUtil.getPublicMethods(clazz);
    }

    public static List getPublicMethods(Class clazz, Filter filter) {
        return ReflectUtil.getPublicMethods(clazz, filter);
    }

    public static List getPublicMethods(Class clazz, Method ... methodArray) {
        return ReflectUtil.getPublicMethods(clazz, methodArray);
    }

    public static List getPublicMethods(Class clazz, String ... stringArray) {
        return ReflectUtil.getPublicMethods(clazz, stringArray);
    }

    public static Method getPublicMethod(Class clazz, String string, Class ... classArray) {
        return ReflectUtil.getPublicMethod(clazz, string, classArray);
    }

    public static Set getDeclaredMethodNames(Class clazz) {
        return ReflectUtil.getMethodNames(clazz);
    }

    public static Method[] getDeclaredMethods(Class clazz) {
        return ReflectUtil.getMethods(clazz);
    }

    public static Method getDeclaredMethodOfObj(Object object, String string, Object ... objectArray) {
        return ClassUtil.getDeclaredMethod(object.getClass(), string, ClassUtil.getClasses(objectArray));
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class ... classArray) {
        return ReflectUtil.getMethod(clazz, string, classArray);
    }

    public static Field getDeclaredField(Class clazz, String string) {
        if (null == clazz || StrUtil.isBlank(string)) {
            return null;
        }
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class clazz) {
        if (null == clazz) {
            return null;
        }
        return clazz.getDeclaredFields();
    }

    public static Set getClassPathResources() {
        return ClassUtil.getClassPathResources(false);
    }

    public static Set getClassPathResources(boolean bl) {
        return ClassUtil.getClassPaths("", bl);
    }

    public static Set getClassPaths(String string) {
        return ClassUtil.getClassPaths(string, false);
    }

    public static Set getClassPaths(String string, boolean bl) {
        Enumeration<URL> enumeration;
        String string2 = string.replace(".", "/");
        try {
            enumeration = ClassUtil.getClassLoader().getResources(string2);
        }
        catch (IOException iOException) {
            throw new UtilException(iOException, "Loading classPath [{}] error!", string2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement().getPath();
            hashSet.add(bl ? URLUtil.decode(string3, CharsetUtil.systemCharsetName()) : string3);
        }
        return hashSet;
    }

    public static String getClassPath() {
        return ClassUtil.getClassPath(false);
    }

    public static String getClassPath(boolean bl) {
        URL uRL = ClassUtil.getClassPathURL();
        String string = bl ? uRL.getPath() : URLUtil.getDecodedPath(uRL);
        return FileUtil.normalize(string);
    }

    public static URL getClassPathURL() {
        return ClassUtil.getResourceURL("");
    }

    public static URL getResourceURL(String string) {
        return ResourceUtil.getResource(string);
    }

    public static List getResources(String string) {
        return ResourceUtil.getResources(string);
    }

    public static URL getResourceUrl(String string, Class clazz) {
        return ResourceUtil.getResource(string, clazz);
    }

    public static String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static ClassLoader getContextClassLoader() {
        return ClassLoaderUtil.getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        return ClassLoaderUtil.getClassLoader();
    }

    public static boolean isAllAssignableFrom(Class[] classArray, Class[] classArray2) {
        if (ArrayUtil.isEmpty(classArray) && ArrayUtil.isEmpty(classArray2)) {
            return true;
        }
        if (null == classArray || null == classArray2) {
            return false;
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class clazz = classArray[i2];
            Class clazz2 = classArray2[i2];
            if (!(ClassUtil.isBasicType(clazz) && ClassUtil.isBasicType(clazz2) ? BasicType.unWrap(clazz) != BasicType.unWrap(clazz2) : false == clazz.isAssignableFrom(clazz2))) continue;
            return false;
        }
        return true;
    }

    public static Class loadClass(String string, boolean bl) {
        return ClassLoaderUtil.loadClass(string, bl);
    }

    public static Class loadClass(String string) {
        return ClassUtil.loadClass(string, true);
    }

    public static Object invoke(String string, Object[] objectArray) {
        return ClassUtil.invoke(string, false, objectArray);
    }

    public static Object invoke(String string, boolean bl, Object ... objectArray) {
        if (StrUtil.isBlank(string)) {
            throw new UtilException("Blank classNameDotMethodName!");
        }
        int n2 = string.lastIndexOf(35);
        if (n2 <= 0) {
            n2 = string.lastIndexOf(46);
        }
        if (n2 <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", string);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        return ClassUtil.invoke(string2, string3, bl, objectArray);
    }

    public static Object invoke(String string, String string2, Object[] objectArray) {
        return ClassUtil.invoke(string, string2, false, objectArray);
    }

    public static Object invoke(String string, String string2, boolean bl, Object ... objectArray) {
        Class clazz = ClassUtil.loadClass(string);
        try {
            Method method = ClassUtil.getDeclaredMethod(clazz, string2, ClassUtil.getClasses(objectArray));
            if (null == method) {
                throw new NoSuchMethodException(StrUtil.format((CharSequence)"No such method: [{}]", string2));
            }
            if (ClassUtil.isStatic(method)) {
                return ReflectUtil.invoke(null, method, objectArray);
            }
            return ReflectUtil.invoke(bl ? Singleton.get(clazz, new Object[0]) : clazz.newInstance(), method, objectArray);
        }
        catch (Exception exception) {
            throw new UtilException(exception);
        }
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.WRAPPER_PRIMITIVE_MAP.containsKey(clazz);
    }

    public static boolean isBasicType(Class clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassUtil.isSimpleValueType(clazz) || clazz.isArray() && ClassUtil.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class clazz) {
        return ClassUtil.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class) || TemporalAccessor.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        if (null == clazz || null == clazz2) {
            return false;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            Class clazz3 = (Class)BasicType.WRAPPER_PRIMITIVE_MAP.get(clazz2);
            return clazz.equals(clazz3);
        }
        Class clazz4 = (Class)BasicType.PRIMITIVE_WRAPPER_MAP.get(clazz2);
        return clazz4 != null && clazz.isAssignableFrom(clazz4);
    }

    public static boolean isPublic(Class clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        Assert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isNotPublic(Class clazz) {
        return false == ClassUtil.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassUtil.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        Assert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && !method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class clazz) {
        return null != clazz && false == clazz.isInterface() && false == ClassUtil.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz.isPrimitive();
    }

    public static boolean isEnum(Class clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static Class getTypeArgument(Class clazz) {
        return ClassUtil.getTypeArgument(clazz, 0);
    }

    public static Class getTypeArgument(Class clazz, int n2) {
        Type type = TypeUtil.getTypeArgument(clazz, n2);
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static String getPackage(Class clazz) {
        if (clazz == null) {
            return "";
        }
        String string = clazz.getName();
        int n2 = string.lastIndexOf(".");
        if (n2 == -1) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static String getPackagePath(Class clazz) {
        return ClassUtil.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class clazz) {
        if (clazz.isPrimitive()) {
            if (Long.TYPE == clazz) {
                return 0L;
            }
            if (Integer.TYPE == clazz) {
                return 0;
            }
            if (Short.TYPE == clazz) {
                return (short)0;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf('\u0000');
            }
            if (Byte.TYPE == clazz) {
                return (byte)0;
            }
            if (Double.TYPE == clazz) {
                return 0.0;
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.TYPE == clazz) {
                return false;
            }
        }
        return null;
    }

    public static Object[] getDefaultValues(Class ... classArray) {
        Object[] objectArray = new Object[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            objectArray[i2] = ClassUtil.getDefaultValue(classArray[i2]);
        }
        return objectArray;
    }

    public static boolean isJdkClass(Class clazz) {
        Package package_ = clazz.getPackage();
        if (null == package_) {
            return false;
        }
        String string = package_.getName();
        return string.startsWith("java.") || string.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static URL getLocation(Class clazz) {
        if (null == clazz) {
            return null;
        }
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String getLocationPath(Class clazz) {
        URL uRL = ClassUtil.getLocation(clazz);
        if (null == uRL) {
            return null;
        }
        return uRL.getPath();
    }
}

