/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.convert.BasicType;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.JarClassLoader;
import com.ccb.core.lang.SimpleCache;
import com.ccb.core.util.StrUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderUtil {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map PRIMITIVE_TYPE_NAME_MAP = new ConcurrentHashMap(32);
    private static final SimpleCache CLASS_CACHE = new SimpleCache();

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassLoaderUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class loadClass(String string) {
        return ClassLoaderUtil.loadClass(string, true);
    }

    public static Class loadClass(String string, boolean bl) {
        return ClassLoaderUtil.loadClass(string, null, bl);
    }

    public static Class loadClass(String string, ClassLoader classLoader, boolean bl) {
        Class<?> clazz;
        block11: {
            Assert.notNull(string, "Name must not be null", new Object[0]);
            clazz = ClassLoaderUtil.loadPrimitiveClass(string);
            if (clazz == null) {
                clazz = (Class)CLASS_CACHE.get(string);
            }
            if (clazz != null) {
                return clazz;
            }
            if (string.endsWith(ARRAY_SUFFIX)) {
                String string2 = string.substring(0, string.length() - ARRAY_SUFFIX.length());
                Class clazz2 = ClassLoaderUtil.loadClass(string2, classLoader, bl);
                clazz = Array.newInstance(clazz2, 0).getClass();
            } else if (string.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && string.endsWith(";")) {
                String string3 = string.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), string.length() - 1);
                Class clazz3 = ClassLoaderUtil.loadClass(string3, classLoader, bl);
                clazz = Array.newInstance(clazz3, 0).getClass();
            } else if (string.startsWith(INTERNAL_ARRAY_PREFIX)) {
                String string4 = string.substring(INTERNAL_ARRAY_PREFIX.length());
                Class clazz4 = ClassLoaderUtil.loadClass(string4, classLoader, bl);
                clazz = Array.newInstance(clazz4, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = ClassLoaderUtil.getClassLoader();
                }
                try {
                    clazz = Class.forName(string, bl, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = ClassLoaderUtil.tryLoadInnerClass(string, classLoader, bl);
                    if (null != clazz) break block11;
                    throw new UtilException(classNotFoundException);
                }
            }
        }
        return (Class)CLASS_CACHE.put(string, clazz);
    }

    public static Class loadPrimitiveClass(String string) {
        Class clazz = null;
        if (StrUtil.isNotBlank(string) && (string = string.trim()).length() <= 8) {
            clazz = (Class)PRIMITIVE_TYPE_NAME_MAP.get(string);
        }
        return clazz;
    }

    public static JarClassLoader getJarClassLoader(File file) {
        return JarClassLoader.load(file);
    }

    public static Class loadClass(File file, String string) {
        try {
            return ClassLoaderUtil.getJarClassLoader(file).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UtilException(classNotFoundException);
        }
    }

    public static boolean isPresent(String string) {
        return ClassLoaderUtil.isPresent(string, null);
    }

    public static boolean isPresent(String string, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.loadClass(string, classLoader, false);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Class tryLoadInnerClass(String string, ClassLoader classLoader, boolean bl) {
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            String string2 = string.substring(0, n2) + '$' + string.substring(n2 + 1);
            try {
                return Class.forName(string2, bl, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList<Object> arrayList = new ArrayList<Object>(32);
        arrayList.addAll(BasicType.PRIMITIVE_WRAPPER_MAP.keySet());
        arrayList.add(boolean[].class);
        arrayList.add(byte[].class);
        arrayList.add(char[].class);
        arrayList.add(double[].class);
        arrayList.add(float[].class);
        arrayList.add(int[].class);
        arrayList.add(long[].class);
        arrayList.add(short[].class);
        arrayList.add(Void.TYPE);
        for (Class clazz : arrayList) {
            PRIMITIVE_TYPE_NAME_MAP.put(clazz.getName(), clazz);
        }
    }
}

