/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.io.FileUtil;
import com.ccb.core.util.StrUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class CharsetUtil {
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String GBK = "GBK";
    public static final Charset CHARSET_ISO_8859_1 = StandardCharsets.ISO_8859_1;
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final Charset CHARSET_GBK;

    public static Charset charset(String string) {
        return StrUtil.isBlank(string) ? Charset.defaultCharset() : Charset.forName(string);
    }

    public static Charset parse(String string) {
        return CharsetUtil.parse(string, Charset.defaultCharset());
    }

    public static Charset parse(String string, Charset charset) {
        Charset charset2;
        if (StrUtil.isBlank(string)) {
            return charset;
        }
        try {
            charset2 = Charset.forName(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            charset2 = charset;
        }
        return charset2;
    }

    public static String convert(String string, String string2, String string3) {
        return CharsetUtil.convert(string, Charset.forName(string2), Charset.forName(string3));
    }

    public static String convert(String string, Charset charset, Charset charset2) {
        if (null == charset) {
            charset = StandardCharsets.ISO_8859_1;
        }
        if (null == charset2) {
            charset2 = StandardCharsets.UTF_8;
        }
        if (StrUtil.isBlank(string) || charset.equals(charset2)) {
            return string;
        }
        return new String(string.getBytes(charset), charset2);
    }

    public static File convert(File file, Charset charset, Charset charset2) {
        String string = FileUtil.readString(file, charset);
        return FileUtil.writeString(string, file, charset2);
    }

    public static String systemCharsetName() {
        return CharsetUtil.systemCharset().name();
    }

    public static Charset systemCharset() {
        return FileUtil.isWindows() ? CHARSET_GBK : CharsetUtil.defaultCharset();
    }

    public static String defaultCharsetName() {
        return CharsetUtil.defaultCharset().name();
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    static {
        Charset charset = null;
        try {
            charset = Charset.forName(GBK);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        CHARSET_GBK = charset;
    }
}

