/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.StrUtil;
import java.util.Set;

public class BooleanUtil {
    private static final Set TRUE_SET = CollUtil.newHashSet("true", "yes", "y", "t", "ok", "1", "on", "\u662f", "\u5bf9", "\u771f", "\u5c0d", "\u221a");

    public static Boolean negate(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return bl != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bl) {
        return Boolean.TRUE.equals(bl);
    }

    public static boolean isFalse(Boolean bl) {
        return Boolean.FALSE.equals(bl);
    }

    public static boolean negate(boolean bl) {
        return !bl;
    }

    public static boolean toBoolean(String string) {
        if (StrUtil.isNotBlank(string)) {
            string = string.trim().toLowerCase();
            return TRUE_SET.contains(string);
        }
        return false;
    }

    public static int toInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public static Integer toInteger(boolean bl) {
        return BooleanUtil.toInt(bl);
    }

    public static char toChar(boolean bl) {
        return (char)BooleanUtil.toInt(bl);
    }

    public static Character toCharacter(boolean bl) {
        return Character.valueOf(BooleanUtil.toChar(bl));
    }

    public static byte toByte(boolean bl) {
        return (byte)BooleanUtil.toInt(bl);
    }

    public static Byte toByteObj(boolean bl) {
        return BooleanUtil.toByte(bl);
    }

    public static long toLong(boolean bl) {
        return BooleanUtil.toInt(bl);
    }

    public static Long toLongObj(boolean bl) {
        return BooleanUtil.toLong(bl);
    }

    public static short toShort(boolean bl) {
        return (short)BooleanUtil.toInt(bl);
    }

    public static Short toShortObj(boolean bl) {
        return BooleanUtil.toShort(bl);
    }

    public static float toFloat(boolean bl) {
        return BooleanUtil.toInt(bl);
    }

    public static Float toFloatObj(boolean bl) {
        return Float.valueOf(BooleanUtil.toFloat(bl));
    }

    public static double toDouble(boolean bl) {
        return BooleanUtil.toInt(bl);
    }

    public static Double toDoubleObj(boolean bl) {
        return BooleanUtil.toDouble(bl);
    }

    public static String toStringTrueFalse(boolean bl) {
        return BooleanUtil.toString(bl, "true", "false");
    }

    public static String toStringOnOff(boolean bl) {
        return BooleanUtil.toString(bl, "on", "off");
    }

    public static String toStringYesNo(boolean bl) {
        return BooleanUtil.toString(bl, "yes", "no");
    }

    public static String toString(boolean bl, String string, String string2) {
        return bl ? string : string2;
    }

    public static boolean and(boolean ... blArray) {
        if (ArrayUtil.isEmpty(blArray)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean bl : blArray) {
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static Boolean andOfWrap(Boolean ... booleanArray) {
        if (ArrayUtil.isEmpty((Object[])booleanArray)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] blArray = (boolean[])Convert.convert(boolean[].class, (Object)booleanArray);
        return BooleanUtil.and(blArray);
    }

    public static boolean or(boolean ... blArray) {
        if (ArrayUtil.isEmpty(blArray)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean bl : blArray) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static Boolean orOfWrap(Boolean ... booleanArray) {
        if (ArrayUtil.isEmpty((Object[])booleanArray)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] blArray = (boolean[])Convert.convert(boolean[].class, (Object)booleanArray);
        return BooleanUtil.or(blArray);
    }

    public static boolean xor(boolean ... blArray) {
        if (ArrayUtil.isEmpty(blArray)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean bl = false;
        for (boolean bl2 : blArray) {
            bl ^= bl2;
        }
        return bl;
    }

    public static Boolean xorOfWrap(Boolean ... booleanArray) {
        if (ArrayUtil.isEmpty((Object[])booleanArray)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] blArray = (boolean[])Convert.convert(boolean[].class, (Object)booleanArray);
        return BooleanUtil.xor(blArray);
    }

    public static boolean isBoolean(Class clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }
}

