/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.text.csv;

import com.ccb.core.io.IORuntimeException;
import com.ccb.core.text.StrBuilder;
import com.ccb.core.text.csv.CsvReadConfig;
import com.ccb.core.text.csv.CsvRow;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public final class CsvParser
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_ROW_CAPACITY = 10;
    private final Reader reader;
    private final CsvReadConfig config;
    private final char[] buf = new char[32768];
    private int bufPos;
    private int bufLen;
    private int copyStart;
    private int preChar = -1;
    private boolean inQuotes;
    private final StrBuilder currentField = new StrBuilder(512);
    private CsvRow header;
    private long lineNo;
    private int firstLineFieldCount = -1;
    private int maxFieldCount;
    private boolean finished;

    public CsvParser(Reader reader, CsvReadConfig csvReadConfig) {
        this.reader = Objects.requireNonNull(reader, "reader must not be null");
        this.config = (CsvReadConfig)ObjectUtil.defaultIfNull(csvReadConfig, CsvReadConfig.defaultConfig());
    }

    public List getHeader() {
        if (!this.config.containsHeader) {
            throw new IllegalStateException("No header available - header parsing is disabled");
        }
        if (this.lineNo == 0L) {
            throw new IllegalStateException("No header available - call nextRow() first");
        }
        return this.header.fields;
    }

    public CsvRow nextRow() {
        while (!this.finished) {
            long l2 = ++this.lineNo;
            List list = this.readLine();
            int n2 = list.size();
            if (n2 < 1) break;
            if (this.config.skipEmptyRows && n2 == 1 && ((String)list.get(0)).isEmpty()) continue;
            if (this.config.errorOnDifferentFieldCount) {
                if (this.firstLineFieldCount == -1) {
                    this.firstLineFieldCount = n2;
                } else if (n2 != this.firstLineFieldCount) {
                    throw new IORuntimeException(String.format("Line %d has %d fields, but first line has %d fields", this.lineNo, n2, this.firstLineFieldCount));
                }
            }
            if (n2 > this.maxFieldCount) {
                this.maxFieldCount = n2;
            }
            if (this.config.containsHeader && null == this.header) {
                this.initHeader(list);
                continue;
            }
            return new CsvRow(l2, null == this.header ? null : this.header.headerMap, list);
        }
        return null;
    }

    private void initHeader(List list) {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            if (!StrUtil.isNotEmpty(string) || linkedHashMap.containsKey(string)) continue;
            linkedHashMap.put(string, i2);
        }
        this.header = new CsvRow(this.lineNo, Collections.unmodifiableMap(linkedHashMap), Collections.unmodifiableList(list));
    }

    private List readLine() {
        ArrayList<String> arrayList = new ArrayList<String>(this.maxFieldCount > 0 ? this.maxFieldCount : 10);
        StrBuilder strBuilder = this.currentField;
        char[] cArray = this.buf;
        int n2 = this.bufPos;
        int n3 = this.preChar;
        int n4 = this.copyStart;
        int n5 = 0;
        while (true) {
            if (this.bufLen == n2) {
                if (n5 > 0) {
                    strBuilder.append(cArray, n4, n5);
                }
                try {
                    this.bufLen = this.reader.read(cArray);
                }
                catch (IOException iOException) {
                    throw new IORuntimeException(iOException);
                }
                if (this.bufLen < 0) {
                    this.finished = true;
                    if (n3 != this.config.fieldSeparator && !strBuilder.hasContent()) break;
                    arrayList.add(StrUtil.unWrap(strBuilder.toStringAndReset(), this.config.textDelimiter));
                    break;
                }
                n5 = 0;
                n2 = 0;
                n4 = 0;
            }
            int n6 = cArray[n2++];
            if (this.inQuotes) {
                if (n6 == this.config.textDelimiter) {
                    this.inQuotes = false;
                } else if ((n6 == 13 || n6 == 10) && n3 != 13) {
                    ++this.lineNo;
                }
                ++n5;
            } else if (n6 == this.config.fieldSeparator) {
                if (n5 > 0) {
                    strBuilder.append(cArray, n4, n5);
                    n5 = 0;
                }
                arrayList.add(StrUtil.unWrap(strBuilder.toStringAndReset(), this.config.textDelimiter));
                n4 = n2;
            } else if (n6 == this.config.textDelimiter) {
                this.inQuotes = true;
                ++n5;
            } else {
                if (n6 == 13) {
                    if (n5 > 0) {
                        strBuilder.append(cArray, n4, n5);
                    }
                    arrayList.add(StrUtil.unWrap(strBuilder.toStringAndReset(), this.config.textDelimiter));
                    n3 = n6;
                    n4 = n2;
                    break;
                }
                if (n6 == 10) {
                    if (n3 != 13) {
                        if (n5 > 0) {
                            strBuilder.append(cArray, n4, n5);
                        }
                        arrayList.add(StrUtil.unWrap(strBuilder.toStringAndReset(), this.config.textDelimiter));
                        n3 = n6;
                        n4 = n2;
                        break;
                    }
                    n4 = n2;
                } else {
                    ++n5;
                }
            }
            n3 = n6;
        }
        this.bufPos = n2;
        this.preChar = n3;
        this.copyStart = n4;
        return arrayList;
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

