/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net.multipart;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IoUtil;
import com.ccb.core.net.multipart.MultipartRequestInputStream;
import com.ccb.core.net.multipart.UploadFileHeader;
import com.ccb.core.net.multipart.UploadSetting;
import com.ccb.core.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UploadFile {
    private static final String TMP_FILE_PREFIX = "hutool-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private final UploadFileHeader header;
    private final UploadSetting setting;
    private int size = -1;
    private byte[] data;
    private File tempFile;

    public UploadFile(UploadFileHeader uploadFileHeader, UploadSetting uploadSetting) {
        this.header = uploadFileHeader;
        this.setting = uploadSetting;
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    public File write(String string) {
        if (this.data != null || this.tempFile != null) {
            return this.write(FileUtil.file(string));
        }
        return null;
    }

    public File write(File file) {
        this.assertValid();
        if (file.isDirectory()) {
            file = new File(file, this.header.getFileName());
        }
        if (this.data != null) {
            FileUtil.writeBytes(this.data, file);
            this.data = null;
        } else if (this.tempFile != null) {
            FileUtil.move(this.tempFile, file, true);
        }
        return file;
    }

    public byte[] getFileContent() {
        this.assertValid();
        if (this.data != null) {
            return this.data;
        }
        if (this.tempFile != null) {
            return FileUtil.readBytes(this.tempFile);
        }
        return null;
    }

    public InputStream getFileInputStream() {
        this.assertValid();
        if (this.data != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.data));
        }
        if (this.tempFile != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.tempFile));
        }
        return null;
    }

    public UploadFileHeader getHeader() {
        return this.header;
    }

    public String getFileName() {
        return this.header == null ? null : this.header.getFileName();
    }

    public int size() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size > 0;
    }

    public boolean isInMemory() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processStream(MultipartRequestInputStream multipartRequestInputStream) {
        int n2;
        OutputStream outputStream;
        if (!this.isAllowedExtension()) {
            this.size = multipartRequestInputStream.skipToBoundary();
            return false;
        }
        this.size = 0;
        int n3 = this.setting.memoryThreshold;
        if (n3 > 0) {
            outputStream = new ByteArrayOutputStream(n3);
            n2 = multipartRequestInputStream.copy(outputStream, n3);
            this.data = ((ByteArrayOutputStream)outputStream).toByteArray();
            if (n2 <= n3) {
                this.size = this.data.length;
                return true;
            }
        }
        this.tempFile = FileUtil.createTempFile(TMP_FILE_PREFIX, TMP_FILE_SUFFIX, FileUtil.touch(this.setting.tmpUploadPath), false);
        outputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        if (this.data != null) {
            this.size = this.data.length;
            ((FilterOutputStream)outputStream).write(this.data);
            this.data = null;
        }
        n2 = this.setting.maxFileSize;
        try {
            if (n2 == -1) {
                this.size += multipartRequestInputStream.copy(outputStream);
                boolean bl = true;
                return bl;
            }
            this.size += multipartRequestInputStream.copy(outputStream, n2 - this.size + 1);
            if (this.size > n2) {
                this.tempFile.delete();
                this.tempFile = null;
                multipartRequestInputStream.skipToBoundary();
                boolean bl = false;
                return bl;
            }
        }
        finally {
            IoUtil.close(outputStream);
        }
        return true;
    }

    private boolean isAllowedExtension() {
        String[] stringArray = this.setting.fileExts;
        boolean bl = this.setting.isAllowFileExts;
        if (stringArray == null || stringArray.length == 0) {
            return bl;
        }
        String string = FileUtil.extName(this.getFileName());
        for (String string2 : this.setting.fileExts) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return bl;
        }
        return !bl;
    }

    private void assertValid() {
        if (!this.isUploaded()) {
            throw new IOException(StrUtil.format((CharSequence)"File [{}] upload fail", this.getFileName()));
        }
    }
}

