/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net.multipart;

import com.ccb.core.net.multipart.UploadFileHeader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class MultipartRequestInputStream
extends BufferedInputStream {
    protected byte[] boundary;
    protected UploadFileHeader lastHeader;

    public MultipartRequestInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public byte readByte() {
        int n2 = super.read();
        if (n2 == -1) {
            throw new IOException("End of HTTP request stream reached");
        }
        return (byte)n2;
    }

    public void skipBytes(int n2) {
        long l2 = super.skip(n2);
        if (l2 != (long)n2) {
            throw new IOException("Unable to skip data in HTTP request");
        }
    }

    public byte[] readBoundary() {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while ((by = this.readByte()) <= 32) {
        }
        byteArrayOutputStream.write(by);
        while ((by = this.readByte()) != 13) {
            byteArrayOutputStream.write(by);
        }
        if (byteArrayOutputStream.size() == 0) {
            throw new IOException("Problems with parsing request: invalid boundary");
        }
        this.skipBytes(1);
        this.boundary = new byte[byteArrayOutputStream.size() + 2];
        System.arraycopy(byteArrayOutputStream.toByteArray(), 0, this.boundary, 2, this.boundary.length - 2);
        this.boundary[0] = 13;
        this.boundary[1] = 10;
        return this.boundary;
    }

    public UploadFileHeader getLastHeader() {
        return this.lastHeader;
    }

    public UploadFileHeader readDataHeader(Charset charset) {
        String string = this.readDataHeaderString(charset);
        this.lastHeader = string != null ? new UploadFileHeader(string) : null;
        return this.lastHeader;
    }

    protected String readDataHeaderString(Charset charset) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (true) {
            byte by;
            if ((by = this.readByte()) != 13) {
                byteArrayOutputStream.write(by);
                continue;
            }
            this.mark(4);
            this.skipBytes(1);
            int n2 = this.read();
            if (n2 == -1) {
                return null;
            }
            if (n2 == 13) break;
            this.reset();
            byteArrayOutputStream.write(by);
        }
        this.reset();
        this.skipBytes(3);
        return charset == null ? byteArrayOutputStream.toString() : byteArrayOutputStream.toString(charset.name());
    }

    public int copy(OutputStream outputStream) {
        byte by;
        int n2 = 0;
        while (!this.isBoundary(by = this.readByte())) {
            outputStream.write(by);
            ++n2;
        }
        return n2;
    }

    public int copy(OutputStream outputStream, int n2) {
        byte by;
        int n3 = 0;
        while (!this.isBoundary(by = this.readByte())) {
            outputStream.write(by);
            if (++n3 <= n2) continue;
            break;
        }
        return n3;
    }

    public int skipToBoundary() {
        byte by;
        int n2 = 0;
        do {
            by = this.readByte();
            ++n2;
        } while (!this.isBoundary(by));
        return n2;
    }

    public boolean isBoundary(byte by) {
        int n2 = this.boundary.length;
        this.mark(n2 + 1);
        int n3 = 0;
        while (by == this.boundary[n3]) {
            by = this.readByte();
            if (++n3 != n2) continue;
            return true;
        }
        this.reset();
        return false;
    }
}

