/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net.multipart;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.map.multi.ListValueMap;
import com.ccb.core.net.multipart.MultipartRequestInputStream;
import com.ccb.core.net.multipart.UploadFile;
import com.ccb.core.net.multipart.UploadFileHeader;
import com.ccb.core.net.multipart.UploadSetting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultipartFormData {
    private final ListValueMap requestParameters = new ListValueMap();
    private final ListValueMap requestFiles = new ListValueMap();
    private final UploadSetting setting;
    private boolean loaded;

    public MultipartFormData() {
        this(null);
    }

    public MultipartFormData(UploadSetting uploadSetting) {
        this.setting = uploadSetting == null ? new UploadSetting() : uploadSetting;
    }

    public void parseRequestStream(InputStream inputStream, Charset charset) {
        UploadFileHeader uploadFileHeader;
        this.setLoaded();
        MultipartRequestInputStream multipartRequestInputStream = new MultipartRequestInputStream(inputStream);
        multipartRequestInputStream.readBoundary();
        while ((uploadFileHeader = multipartRequestInputStream.readDataHeader(charset)) != null) {
            Object object;
            Object object2;
            if (uploadFileHeader.isFile) {
                object2 = uploadFileHeader.fileName;
                if (((String)object2).length() > 0 && uploadFileHeader.contentType.contains("application/x-macbinary")) {
                    multipartRequestInputStream.skipBytes(128);
                }
                object = new UploadFile(uploadFileHeader, this.setting);
                ((UploadFile)object).processStream(multipartRequestInputStream);
                this.putFile(uploadFileHeader.formFieldName, (UploadFile)object);
            } else {
                object2 = new ByteArrayOutputStream(1024);
                multipartRequestInputStream.copy((OutputStream)object2);
                object = charset != null ? new String(((ByteArrayOutputStream)object2).toByteArray(), charset) : new String(((ByteArrayOutputStream)object2).toByteArray());
                this.putParameter(uploadFileHeader.formFieldName, (String)object);
            }
            multipartRequestInputStream.skipBytes(1);
            multipartRequestInputStream.mark(1);
            int n2 = multipartRequestInputStream.read();
            if (n2 == -1 || n2 == 45) {
                multipartRequestInputStream.reset();
                break;
            }
            multipartRequestInputStream.reset();
        }
    }

    public String getParam(String string) {
        List list = this.getListParam(string);
        if (CollUtil.isNotEmpty(list)) {
            return (String)list.get(0);
        }
        return null;
    }

    public Set getParamNames() {
        return this.requestParameters.keySet();
    }

    public String[] getArrayParam(String string) {
        List list = this.getListParam(string);
        if (null != list) {
            return list.toArray(new String[0]);
        }
        return null;
    }

    public List getListParam(String string) {
        return this.requestParameters.get(string);
    }

    public Map getParamMap() {
        return Convert.toMap(String.class, String[].class, this.getParamListMap());
    }

    public ListValueMap getParamListMap() {
        return this.requestParameters;
    }

    public UploadFile getFile(String string) {
        UploadFile[] uploadFileArray = this.getFiles(string);
        if (uploadFileArray != null && uploadFileArray.length > 0) {
            return uploadFileArray[0];
        }
        return null;
    }

    public UploadFile[] getFiles(String string) {
        List list = this.getFileList(string);
        if (null != list) {
            return list.toArray(new UploadFile[0]);
        }
        return null;
    }

    public List getFileList(String string) {
        return this.requestFiles.get(string);
    }

    public Set getFileParamNames() {
        return this.requestFiles.keySet();
    }

    public Map getFileMap() {
        return Convert.toMap(String.class, UploadFile[].class, this.getFileListValueMap());
    }

    public ListValueMap getFileListValueMap() {
        return this.requestFiles;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void putFile(String string, UploadFile uploadFile) {
        this.requestFiles.putValue(string, uploadFile);
    }

    private void putParameter(String string, String string2) {
        this.requestParameters.putValue(string, string2);
    }

    private void setLoaded() {
        if (this.loaded) {
            throw new IOException("Multi-part request already parsed.");
        }
        this.loaded = true;
    }
}

