/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net;

import com.ccb.core.convert.Convert;
import com.ccb.core.lang.Validator;
import com.ccb.core.net.MaskBit;
import com.ccb.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;

public class Ipv4Util {
    public static final String IP_SPLIT_MARK = "-";
    public static final String IP_MASK_SPLIT_MARK = "/";
    public static final int IP_MASK_MAX = 32;

    public static String formatIpBlock(String string, String string2) {
        return string + IP_MASK_SPLIT_MARK + Ipv4Util.getMaskBitByMask(string2);
    }

    public static List list(String string, boolean bl) {
        if (string.contains(IP_SPLIT_MARK)) {
            String[] stringArray = string.split(IP_SPLIT_MARK);
            return Ipv4Util.list(stringArray[0], stringArray[1]);
        }
        if (string.contains(IP_MASK_SPLIT_MARK)) {
            String[] stringArray = string.split(IP_MASK_SPLIT_MARK);
            return Ipv4Util.list(stringArray[0], Integer.parseInt(stringArray[1]), bl);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return arrayList;
    }

    public static List list(String string, int n2, boolean bl) {
        List<String> list = new ArrayList<String>();
        if (n2 == 32) {
            if (Boolean.TRUE.equals(bl)) {
                list.add(string);
            }
        } else {
            String string2 = Ipv4Util.getBeginIpStr(string, n2);
            String string3 = Ipv4Util.getEndIpStr(string, n2);
            String string4 = string2.split("\\.")[0] + "." + string2.split("\\.")[1] + "." + string2.split("\\.")[2] + ".";
            String string5 = string3.split("\\.")[0] + "." + string3.split("\\.")[1] + "." + string3.split("\\.")[2] + ".";
            if (Boolean.TRUE.equals(bl)) {
                string2 = string4 + Integer.parseInt(string2.split("\\.")[3]);
                string3 = string5 + Integer.parseInt(string3.split("\\.")[3]);
            } else {
                string2 = string4 + (Integer.parseInt(string2.split("\\.")[3]) + 1);
                string3 = string5 + (Integer.parseInt(string3.split("\\.")[3]) - 1);
            }
            list = Ipv4Util.list(string2, string3);
        }
        return list;
    }

    public static List list(String string, String string2) {
        int[] nArray = (int[])Convert.convert(int[].class, (Object)StrUtil.splitToArray(string, '.'));
        int[] nArray2 = (int[])Convert.convert(int[].class, (Object)StrUtil.splitToArray(string2, '.'));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = nArray[0]; i2 <= nArray2[0]; ++i2) {
            for (int i3 = i2 == nArray[0] ? nArray[1] : 0; i3 <= (i2 == nArray2[0] ? nArray2[1] : 255); ++i3) {
                for (int i4 = i3 == nArray[1] ? nArray[2] : 0; i4 <= (i3 == nArray2[1] ? nArray2[2] : 255); ++i4) {
                    for (int i5 = i4 == nArray[2] ? nArray[3] : 0; i5 <= (i4 == nArray2[2] ? nArray2[3] : 255); ++i5) {
                        arrayList.add(i2 + "." + i3 + "." + i4 + "." + i5);
                    }
                }
            }
        }
        return arrayList;
    }

    public static String longToIpv4(long l2) {
        StringBuilder stringBuilder = StrUtil.builder();
        stringBuilder.append(l2 >>> 24);
        stringBuilder.append(".");
        stringBuilder.append((l2 & 0xFFFFFFL) >>> 16);
        stringBuilder.append(".");
        stringBuilder.append((l2 & 0xFFFFL) >>> 8);
        stringBuilder.append(".");
        stringBuilder.append(l2 & 0xFFL);
        return stringBuilder.toString();
    }

    public static long ipv4ToLong(String string) {
        if (Validator.isIpv4(string)) {
            long[] lArray = new long[4];
            int n2 = string.indexOf(".");
            int n3 = string.indexOf(".", n2 + 1);
            int n4 = string.indexOf(".", n3 + 1);
            lArray[0] = Long.parseLong(string.substring(0, n2));
            lArray[1] = Long.parseLong(string.substring(n2 + 1, n3));
            lArray[2] = Long.parseLong(string.substring(n3 + 1, n4));
            lArray[3] = Long.parseLong(string.substring(n4 + 1));
            return (lArray[0] << 24) + (lArray[1] << 16) + (lArray[2] << 8) + lArray[3];
        }
        return 0L;
    }

    public static String getBeginIpStr(String string, int n2) {
        return Ipv4Util.longToIpv4(Ipv4Util.getBeginIpLong(string, n2));
    }

    private static Long getBeginIpLong(String string, int n2) {
        return Ipv4Util.ipv4ToLong(string) & Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(n2));
    }

    public static String getEndIpStr(String string, int n2) {
        return Ipv4Util.longToIpv4(Ipv4Util.getEndIpLong(string, n2));
    }

    public static int getMaskBitByMask(String string) {
        int n2 = 0;
        for (String string2 : StrUtil.split((CharSequence)string, ',')) {
            StringBuffer stringBuffer = Ipv4Util.toBin(Integer.parseInt(string2));
            String string3 = stringBuffer.reverse().toString();
            int n3 = 0;
            for (int i2 = 0; i2 < string3.length() && (i2 = string3.indexOf(49, i2)) != -1; ++i2) {
                ++n3;
            }
            n2 += n3;
        }
        return n2;
    }

    public static int countByMaskBit(int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !bl && (n2 <= 0 || n2 >= 32);
        if (bl2) {
            return 0;
        }
        if (bl) {
            return (int)Math.pow(2.0, 32 - n2);
        }
        return (int)Math.pow(2.0, 32 - n2) - 2;
    }

    public static String getMaskByMaskBit(int n2) {
        return MaskBit.get(n2);
    }

    public static String getMaskByIpRange(String string, String string2) {
        long l2 = Ipv4Util.ipv4ToLong(string2);
        long l3 = Ipv4Util.ipv4ToLong(string);
        if (l3 > l2) {
            throw new IllegalArgumentException("to IP must be greater than from IP!");
        }
        String[] stringArray = StrUtil.splitToArray(string, '.');
        String[] stringArray2 = StrUtil.splitToArray(string2, '.');
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            stringBuilder.append(255 - Integer.parseInt(stringArray2[i2]) + Integer.parseInt(stringArray[i2])).append(".");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static int countByIpRange(String string, String string2) {
        long l2 = Ipv4Util.ipv4ToLong(string2);
        long l3 = Ipv4Util.ipv4ToLong(string);
        if (l3 > l2) {
            throw new IllegalArgumentException("to IP must be greater than from IP!");
        }
        int n2 = 1;
        int[] nArray = StrUtil.split((CharSequence)string, '.').stream().mapToInt(Integer::parseInt).toArray();
        int[] nArray2 = StrUtil.split((CharSequence)string2, '.').stream().mapToInt(Integer::parseInt).toArray();
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            n2 = (int)((double)n2 + (double)(nArray2[i2] - nArray[i2]) * Math.pow(256.0, nArray.length - i2 - 1));
        }
        return n2;
    }

    private static Long getEndIpLong(String string, int n2) {
        return Ipv4Util.getBeginIpLong(string, n2) + (Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit(n2)) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static StringBuffer toBin(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2 % 2);
        n2 /= 2;
        while (n2 > 0) {
            stringBuffer.append(n2 % 2);
            n2 /= 2;
        }
        return stringBuffer;
    }
}

