/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.math;

import com.ccb.core.util.StrUtil;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;

public class Money
implements Serializable,
Comparable {
    private static final long serialVersionUID = -1004117971993390293L;
    public static final String DEFAULT_CURRENCY_CODE = "CNY";
    public static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.HALF_EVEN;
    private static final int[] CENT_FACTORS = new int[]{1, 10, 100, 1000};
    private long cent;
    private final Currency currency;

    public Money() {
        this(0.0);
    }

    public Money(long l2, int n2) {
        this(l2, n2, Currency.getInstance(DEFAULT_CURRENCY_CODE));
    }

    public Money(long l2, int n2, Currency currency) {
        this.currency = currency;
        this.cent = l2 * (long)this.getCentFactor() + (long)(n2 % this.getCentFactor());
    }

    public Money(String string) {
        this(string, Currency.getInstance(DEFAULT_CURRENCY_CODE));
    }

    public Money(String string, Currency currency) {
        this(new BigDecimal(string), currency);
    }

    public Money(String string, Currency currency, RoundingMode roundingMode) {
        this(new BigDecimal(string), currency, roundingMode);
    }

    public Money(double d2) {
        this(d2, Currency.getInstance(DEFAULT_CURRENCY_CODE));
    }

    public Money(double d2, Currency currency) {
        this.currency = currency;
        this.cent = Math.round(d2 * (double)this.getCentFactor());
    }

    public Money(BigDecimal bigDecimal) {
        this(bigDecimal, Currency.getInstance(DEFAULT_CURRENCY_CODE));
    }

    public Money(BigDecimal bigDecimal, RoundingMode roundingMode) {
        this(bigDecimal, Currency.getInstance(DEFAULT_CURRENCY_CODE), roundingMode);
    }

    public Money(BigDecimal bigDecimal, Currency currency) {
        this(bigDecimal, currency, DEFAULT_ROUNDING_MODE);
    }

    public Money(BigDecimal bigDecimal, Currency currency, RoundingMode roundingMode) {
        this.currency = currency;
        this.cent = this.rounding(bigDecimal.movePointRight(currency.getDefaultFractionDigits()), roundingMode);
    }

    public BigDecimal getAmount() {
        return BigDecimal.valueOf(this.cent, this.currency.getDefaultFractionDigits());
    }

    public void setAmount(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            this.cent = this.rounding(bigDecimal.movePointRight(2), DEFAULT_ROUNDING_MODE);
        }
    }

    public long getCent() {
        return this.cent;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public int getCentFactor() {
        return CENT_FACTORS[this.currency.getDefaultFractionDigits()];
    }

    public boolean equals(Object object) {
        return object instanceof Money && this.equals((Money)object);
    }

    public boolean equals(Money money) {
        return this.currency.equals(money.currency) && this.cent == money.cent;
    }

    public int hashCode() {
        return (int)(this.cent ^ this.cent >>> 32);
    }

    public int compareTo(Money money) {
        this.assertSameCurrencyAs(money);
        return Long.compare(this.cent, money.cent);
    }

    public boolean greaterThan(Money money) {
        return this.compareTo(money) > 0;
    }

    public Money add(Money money) {
        this.assertSameCurrencyAs(money);
        return this.newMoneyWithSameCurrency(this.cent + money.cent);
    }

    public Money addTo(Money money) {
        this.assertSameCurrencyAs(money);
        this.cent += money.cent;
        return this;
    }

    public Money subtract(Money money) {
        this.assertSameCurrencyAs(money);
        return this.newMoneyWithSameCurrency(this.cent - money.cent);
    }

    public Money subtractFrom(Money money) {
        this.assertSameCurrencyAs(money);
        this.cent -= money.cent;
        return this;
    }

    public Money multiply(long l2) {
        return this.newMoneyWithSameCurrency(this.cent * l2);
    }

    public Money multiplyBy(long l2) {
        this.cent *= l2;
        return this;
    }

    public Money multiply(double d2) {
        return this.newMoneyWithSameCurrency(Math.round((double)this.cent * d2));
    }

    public Money multiplyBy(double d2) {
        this.cent = Math.round((double)this.cent * d2);
        return this;
    }

    public Money multiply(BigDecimal bigDecimal) {
        return this.multiply(bigDecimal, DEFAULT_ROUNDING_MODE);
    }

    public Money multiplyBy(BigDecimal bigDecimal) {
        return this.multiplyBy(bigDecimal, DEFAULT_ROUNDING_MODE);
    }

    public Money multiply(BigDecimal bigDecimal, RoundingMode roundingMode) {
        BigDecimal bigDecimal2 = BigDecimal.valueOf(this.cent).multiply(bigDecimal);
        return this.newMoneyWithSameCurrency(this.rounding(bigDecimal2, roundingMode));
    }

    public Money multiplyBy(BigDecimal bigDecimal, RoundingMode roundingMode) {
        BigDecimal bigDecimal2 = BigDecimal.valueOf(this.cent).multiply(bigDecimal);
        this.cent = this.rounding(bigDecimal2, roundingMode);
        return this;
    }

    public Money divide(double d2) {
        return this.newMoneyWithSameCurrency(Math.round((double)this.cent / d2));
    }

    public Money divideBy(double d2) {
        this.cent = Math.round((double)this.cent / d2);
        return this;
    }

    public Money divide(BigDecimal bigDecimal) {
        return this.divide(bigDecimal, DEFAULT_ROUNDING_MODE);
    }

    public Money divide(BigDecimal bigDecimal, RoundingMode roundingMode) {
        BigDecimal bigDecimal2 = BigDecimal.valueOf(this.cent).divide(bigDecimal, roundingMode);
        return this.newMoneyWithSameCurrency(bigDecimal2.longValue());
    }

    public Money divideBy(BigDecimal bigDecimal) {
        return this.divideBy(bigDecimal, DEFAULT_ROUNDING_MODE);
    }

    public Money divideBy(BigDecimal bigDecimal, RoundingMode roundingMode) {
        BigDecimal bigDecimal2 = BigDecimal.valueOf(this.cent).divide(bigDecimal, roundingMode);
        this.cent = bigDecimal2.longValue();
        return this;
    }

    public Money[] allocate(int n2) {
        int n3;
        Money[] moneyArray = new Money[n2];
        Money money = this.newMoneyWithSameCurrency(this.cent / (long)n2);
        Money money2 = this.newMoneyWithSameCurrency(money.cent + 1L);
        int n4 = (int)this.cent % n2;
        for (n3 = 0; n3 < n4; ++n3) {
            moneyArray[n3] = money2;
        }
        for (n3 = n4; n3 < n2; ++n3) {
            moneyArray[n3] = money;
        }
        return moneyArray;
    }

    public Money[] allocate(long[] lArray) {
        int n2;
        Money[] moneyArray = new Money[lArray.length];
        long l2 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            l2 += lArray[i2];
        }
        long l3 = this.cent;
        for (n2 = 0; n2 < moneyArray.length; ++n2) {
            moneyArray[n2] = this.newMoneyWithSameCurrency(this.cent * lArray[n2] / l2);
            l3 -= moneyArray[n2].cent;
        }
        n2 = 0;
        while ((long)n2 < l3) {
            ++moneyArray[n2].cent;
            ++n2;
        }
        return moneyArray;
    }

    public String toString() {
        return this.getAmount().toString();
    }

    protected void assertSameCurrencyAs(Money money) {
        if (!this.currency.equals(money.currency)) {
            throw new IllegalArgumentException("Money math currency mismatch.");
        }
    }

    protected long rounding(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return bigDecimal.setScale(0, roundingMode).longValue();
    }

    protected Money newMoneyWithSameCurrency(long l2) {
        Money money = new Money(0.0, this.currency);
        money.cent = l2;
        return money;
    }

    public String dump() {
        return StrUtil.builder().append("cent = ").append(this.cent).append(File.separatorChar).append("currency = ").append(this.currency).toString();
    }

    public void setCent(long l2) {
        this.cent = l2;
    }
}

