/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.map;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.lang.Editor;
import com.ccb.core.lang.Filter;
import com.ccb.core.lang.Pair;
import com.ccb.core.lang.TypeReference;
import com.ccb.core.map.CamelCaseLinkedMap;
import com.ccb.core.map.CamelCaseMap;
import com.ccb.core.map.MapBuilder;
import com.ccb.core.map.MapProxy;
import com.ccb.core.map.MapUtil$1;
import com.ccb.core.map.MapWrapper;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return null != map && false == map.isEmpty();
    }

    public static Map emptyIfNull(Map map) {
        return null == map ? Collections.emptyMap() : map;
    }

    public static Map defaultIfEmpty(Map map, Map map2) {
        return MapUtil.isEmpty(map) ? map2 : map;
    }

    public static HashMap newHashMap() {
        return new HashMap();
    }

    public static HashMap newHashMap(int n2, boolean bl) {
        int n3 = (int)((float)n2 / 0.75f) + 1;
        return bl ? new LinkedHashMap(n3) : new HashMap(n3);
    }

    public static HashMap newHashMap(int n2) {
        return MapUtil.newHashMap(n2, false);
    }

    public static HashMap newHashMap(boolean bl) {
        return MapUtil.newHashMap(16, bl);
    }

    public static TreeMap newTreeMap(Comparator comparator) {
        return new TreeMap(comparator);
    }

    public static TreeMap newTreeMap(Map map, Comparator comparator) {
        TreeMap treeMap = new TreeMap(comparator);
        if (!MapUtil.isEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static Map newIdentityMap(int n2) {
        return new IdentityHashMap(n2);
    }

    public static ConcurrentHashMap newConcurrentHashMap() {
        return new ConcurrentHashMap(16);
    }

    public static ConcurrentHashMap newConcurrentHashMap(int n2) {
        int n3 = n2 <= 0 ? 16 : n2;
        return new ConcurrentHashMap(n3);
    }

    public static ConcurrentHashMap newConcurrentHashMap(Map map) {
        if (MapUtil.isEmpty(map)) {
            return new ConcurrentHashMap(16);
        }
        return new ConcurrentHashMap(map);
    }

    public static Map createMap(Class clazz) {
        if (clazz.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        return (Map)ReflectUtil.newInstance(clazz, new Object[0]);
    }

    public static HashMap of(Object object, Object object2) {
        return MapUtil.of(object, object2, false);
    }

    public static HashMap of(Object object, Object object2, boolean bl) {
        HashMap hashMap = MapUtil.newHashMap(bl);
        hashMap.put(object, object2);
        return hashMap;
    }

    public static Map of(Pair ... pairArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Pair pair : pairArray) {
            hashMap.put(pair.getKey(), pair.getValue());
        }
        return hashMap;
    }

    public static HashMap of(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>((int)((double)objectArray.length * 1.5));
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object e2;
            Object e3;
            Object object;
            Object object2 = objectArray[i2];
            if (object2 instanceof Map.Entry) {
                object = (Object[])object2;
                hashMap.put(object.getKey(), object.getValue());
                continue;
            }
            if (object2 instanceof Object[]) {
                object = (Object[])object2;
                if (((Object[])object).length <= 1) continue;
                hashMap.put(object[0], object[1]);
                continue;
            }
            if (object2 instanceof Iterable) {
                object = ((Iterable)object2).iterator();
                if (!object.hasNext()) continue;
                e3 = object.next();
                if (!object.hasNext()) continue;
                e2 = object.next();
                hashMap.put(e3, e2);
                continue;
            }
            if (object2 instanceof Iterator) {
                object = (Iterator)object2;
                if (!object.hasNext()) continue;
                e3 = object.next();
                if (!object.hasNext()) continue;
                e2 = object.next();
                hashMap.put(e3, e2);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i2, object2));
        }
        return hashMap;
    }

    public static Map toListMap(Iterable iterable) {
        HashMap hashMap = new HashMap();
        if (CollUtil.isEmpty(iterable)) {
            return hashMap;
        }
        for (Map map : iterable) {
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                Object k2 = entry.getKey();
                List list = (List)hashMap.get(k2);
                if (null == list) {
                    list = CollUtil.newArrayList(entry.getValue());
                    hashMap.put(k2, list);
                    continue;
                }
                list.add(entry.getValue());
            }
        }
        return hashMap;
    }

    public static List toMapList(Map map) {
        boolean bl;
        ArrayList arrayList = new ArrayList();
        if (MapUtil.isEmpty(map)) {
            return arrayList;
        }
        int n2 = 0;
        do {
            bl = true;
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                ArrayList arrayList2 = CollUtil.newArrayList((Iterable)entry.getValue());
                int n3 = arrayList2.size();
                if (n2 >= n3) continue;
                hashMap.put(entry.getKey(), arrayList2.get(n2));
                if (n2 == n3 - 1) continue;
                bl = false;
            }
            if (!hashMap.isEmpty()) {
                arrayList.add(hashMap);
            }
            ++n2;
        } while (!bl);
        return arrayList;
    }

    public static Map toCamelCaseMap(Map map) {
        return map instanceof LinkedHashMap ? new CamelCaseLinkedMap(map) : new CamelCaseMap(map);
    }

    public static Object[][] toObjectArray(Map map) {
        if (map == null) {
            return null;
        }
        Object[][] objectArray = new Object[map.size()][2];
        if (map.isEmpty()) {
            return objectArray;
        }
        int n2 = 0;
        for (Map.Entry entry : map.entrySet()) {
            objectArray[n2][0] = entry.getKey();
            objectArray[n2][1] = entry.getValue();
            ++n2;
        }
        return objectArray;
    }

    public static String join(Map map, String string, String string2, String ... stringArray) {
        return MapUtil.join(map, string, string2, false, stringArray);
    }

    public static String sortJoin(Map map, String string, String string2, boolean bl, String ... stringArray) {
        return MapUtil.join((Map)MapUtil.sort(map), string, string2, bl, stringArray);
    }

    public static String joinIgnoreNull(Map map, String string, String string2, String ... stringArray) {
        return MapUtil.join(map, string, string2, true, stringArray);
    }

    public static String join(Map map, String string, String string2, boolean bl, String ... stringArray) {
        StringBuilder stringBuilder = StrUtil.builder();
        boolean bl2 = true;
        if (MapUtil.isNotEmpty(map)) {
            for (Map.Entry entry : map.entrySet()) {
                if (bl && (entry.getKey() == null || entry.getValue() == null)) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(Convert.toStr(entry.getKey())).append(string2).append(Convert.toStr(entry.getValue()));
            }
        }
        if (ArrayUtil.isNotEmpty(stringArray)) {
            for (String string3 : stringArray) {
                stringBuilder.append(string3);
            }
        }
        return stringBuilder.toString();
    }

    public static Map filter(Map map, Editor editor) {
        if (null == map || null == editor) {
            return map;
        }
        Map map2 = (Map)ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry entry : map.entrySet()) {
            Map.Entry entry2 = (Map.Entry)editor.edit(entry);
            if (null == entry2) continue;
            map2.put(entry2.getKey(), entry2.getValue());
        }
        return map2;
    }

    public static Map filter(Map map, Filter filter) {
        if (null == map || null == filter) {
            return map;
        }
        Map map2 = (Map)ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry entry : map.entrySet()) {
            if (!filter.accept(entry)) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static Map filter(Map map, Object ... objectArray) {
        Map map2 = (Map)ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Object object : objectArray) {
            if (!map.containsKey(object)) continue;
            map2.put(object, map.get(object));
        }
        return map2;
    }

    public static Map reverse(Map map) {
        return MapUtil.filter(map, (Object entry) -> new MapUtil$1((Map.Entry)entry));
    }

    public static Map inverse(Map map) {
        Map map2 = MapUtil.createMap(map.getClass());
        map.forEach((object, object2) -> map2.put(object2, object));
        return map2;
    }

    public static TreeMap sort(Map map) {
        return MapUtil.sort(map, null);
    }

    public static TreeMap sort(Map map, Comparator comparator) {
        TreeMap treeMap;
        if (null == map) {
            return null;
        }
        if (map instanceof TreeMap) {
            treeMap = (TreeMap)map;
            if (null == comparator || comparator.equals(treeMap.comparator())) {
                return treeMap;
            }
        } else {
            treeMap = MapUtil.newTreeMap(map, comparator);
        }
        return treeMap;
    }

    public static MapProxy createProxy(Map map) {
        return MapProxy.create(map);
    }

    public static MapWrapper wrap(Map map) {
        return new MapWrapper(map);
    }

    public static Map unmodifiable(Map map) {
        return Collections.unmodifiableMap(map);
    }

    public static MapBuilder builder() {
        return MapUtil.builder(new HashMap());
    }

    public static MapBuilder builder(Map map) {
        return new MapBuilder(map);
    }

    public static MapBuilder builder(Object object, Object object2) {
        return MapUtil.builder(new HashMap()).put(object, object2);
    }

    public static Map getAny(Map map, Object ... objectArray) {
        return MapUtil.filter(map, (Object entry) -> ArrayUtil.contains(objectArray, entry.getKey()));
    }

    public static Map removeAny(Map map, Object ... objectArray) {
        for (Object object : objectArray) {
            map.remove(object);
        }
        return map;
    }

    public static String getStr(Map map, Object object) {
        return (String)MapUtil.get(map, object, String.class);
    }

    public static String getStr(Map map, Object object, String string) {
        return (String)MapUtil.get(map, object, String.class, (Object)string);
    }

    public static Integer getInt(Map map, Object object) {
        return (Integer)MapUtil.get(map, object, Integer.class);
    }

    public static Integer getInt(Map map, Object object, Integer n2) {
        return (Integer)MapUtil.get(map, object, Integer.class, (Object)n2);
    }

    public static Double getDouble(Map map, Object object) {
        return (Double)MapUtil.get(map, object, Double.class);
    }

    public static Double getDouble(Map map, Object object, Double d2) {
        return (Double)MapUtil.get(map, object, Double.class, (Object)d2);
    }

    public static Float getFloat(Map map, Object object) {
        return (Float)MapUtil.get(map, object, Float.class);
    }

    public static Float getFloat(Map map, Object object, Float f2) {
        return (Float)MapUtil.get(map, object, Float.class, (Object)f2);
    }

    public static Short getShort(Map map, Object object) {
        return (Short)MapUtil.get(map, object, Short.class);
    }

    public static Short getShort(Map map, Object object, Short s2) {
        return (Short)MapUtil.get(map, object, Short.class, (Object)s2);
    }

    public static Boolean getBool(Map map, Object object) {
        return (Boolean)MapUtil.get(map, object, Boolean.class);
    }

    public static Boolean getBool(Map map, Object object, Boolean bl) {
        return (Boolean)MapUtil.get(map, object, Boolean.class, (Object)bl);
    }

    public static Character getChar(Map map, Object object) {
        return (Character)MapUtil.get(map, object, Character.class);
    }

    public static Character getChar(Map map, Object object, Character c2) {
        return (Character)MapUtil.get(map, object, Character.class, (Object)c2);
    }

    public static Long getLong(Map map, Object object) {
        return (Long)MapUtil.get(map, object, Long.class);
    }

    public static Long getLong(Map map, Object object, Long l2) {
        return (Long)MapUtil.get(map, object, Long.class, (Object)l2);
    }

    public static Date getDate(Map map, Object object) {
        return (Date)MapUtil.get(map, object, Date.class);
    }

    public static Date getDate(Map map, Object object, Date date) {
        return (Date)MapUtil.get(map, object, Date.class, (Object)date);
    }

    public static Object get(Map map, Object object, Class clazz) {
        return MapUtil.get(map, object, clazz, null);
    }

    public static Object get(Map map, Object object, Class clazz, Object object2) {
        return null == map ? null : Convert.convert(clazz, map.get(object), object2);
    }

    public static Object get(Map map, Object object, TypeReference typeReference) {
        return MapUtil.get(map, object, typeReference, null);
    }

    public static Object get(Map map, Object object, TypeReference typeReference, Object object2) {
        return null == map ? null : Convert.convert(typeReference, map.get(object), object2);
    }

    public static Map renameKey(Map map, Object object, Object object2) {
        if (MapUtil.isNotEmpty(map) && map.containsKey(object)) {
            if (map.containsKey(object2)) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"The key '{}' exist !", object2));
            }
            map.put(object2, map.remove(object));
        }
        return map;
    }

    public static Map removeNullValue(Map map) {
        if (MapUtil.isEmpty(map)) {
            return map;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (null != entry.getValue()) continue;
            iterator.remove();
        }
        return map;
    }

    public static Map empty() {
        return Collections.emptyMap();
    }

    public static Map empty(Class clazz) {
        if (null == clazz) {
            return Collections.emptyMap();
        }
        if (NavigableMap.class == clazz) {
            return Collections.emptyNavigableMap();
        }
        if (SortedMap.class == clazz) {
            return Collections.emptySortedMap();
        }
        if (Map.class == clazz) {
            return Collections.emptyMap();
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"[{}] is not support to get empty!", clazz));
    }

    public static void clear(Map ... mapArray) {
        for (Map map : mapArray) {
            if (!MapUtil.isNotEmpty(map)) continue;
            map.clear();
        }
    }
}

