/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang.mutable;

import com.ccb.core.lang.mutable.Mutable;
import com.ccb.core.util.NumberUtil;

public class MutableDouble
extends Number
implements Mutable,
Comparable {
    private static final long serialVersionUID = 1L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double d2) {
        this.value = d2;
    }

    public MutableDouble(Number number) {
        this(number.doubleValue());
    }

    public MutableDouble(String string) {
        this.value = Double.parseDouble(string);
    }

    @Override
    public Double get() {
        return this.value;
    }

    public void set(double d2) {
        this.value = d2;
    }

    public void set(Number number) {
        this.value = number.doubleValue();
    }

    public MutableDouble increment() {
        this.value += 1.0;
        return this;
    }

    public MutableDouble decrement() {
        this.value -= 1.0;
        return this;
    }

    public MutableDouble add(double d2) {
        this.value += d2;
        return this;
    }

    public MutableDouble add(Number number) {
        this.value += number.doubleValue();
        return this;
    }

    public MutableDouble subtract(double d2) {
        this.value -= d2;
        return this;
    }

    public MutableDouble subtract(Number number) {
        this.value -= number.doubleValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableDouble) {
            return Double.doubleToLongBits(((MutableDouble)object).value) == Double.doubleToLongBits(this.value);
        }
        return false;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.value);
        return (int)(l2 ^ l2 >>> 32);
    }

    public int compareTo(MutableDouble mutableDouble) {
        return NumberUtil.compare(this.value, mutableDouble.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

