/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.lang.UUID$Holder;
import com.ccb.core.util.RandomUtil;
import com.ccb.core.util.StrUtil;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class UUID
implements Serializable,
Comparable {
    private static final long serialVersionUID = -1185015143654744140L;
    private final long mostSigBits;
    private final long leastSigBits;

    private UUID(byte[] byArray) {
        int n2;
        long l2 = 0L;
        long l3 = 0L;
        assert (byArray.length == 16) : "data must be 16 bytes in length";
        for (n2 = 0; n2 < 8; ++n2) {
            l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
        }
        for (n2 = 8; n2 < 16; ++n2) {
            l3 = l3 << 8 | (long)(byArray[n2] & 0xFF);
        }
        this.mostSigBits = l2;
        this.leastSigBits = l3;
    }

    public UUID(long l2, long l3) {
        this.mostSigBits = l2;
        this.leastSigBits = l3;
    }

    public static UUID fastUUID() {
        return UUID.randomUUID(false);
    }

    public static UUID randomUUID() {
        return UUID.randomUUID(true);
    }

    public static UUID randomUUID(boolean bl) {
        Random random = bl ? UUID$Holder.NUMBER_GENERATOR : RandomUtil.getRandom();
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        return new UUID(byArray);
    }

    public static UUID nameUUIDFromBytes(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MD5 not supported");
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        byArray2[6] = (byte)(byArray2[6] & 0xF);
        byArray2[6] = (byte)(byArray2[6] | 0x30);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        return new UUID(byArray2);
    }

    public static UUID fromString(String string) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + string);
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            stringArray[i2] = "0x" + stringArray[i2];
        }
        long l2 = Long.decode(stringArray[0]);
        l2 <<= 16;
        l2 |= Long.decode(stringArray[1]).longValue();
        l2 <<= 16;
        long l3 = Long.decode(stringArray[3]);
        l3 <<= 48;
        return new UUID(l2 |= Long.decode(stringArray[2]).longValue(), l3 |= Long.decode(stringArray[4]).longValue());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        return (int)(this.mostSigBits >> 12 & 0xFL);
    }

    public int variant() {
        return (int)(this.leastSigBits >>> (int)(64L - (this.leastSigBits >>> 62)) & this.leastSigBits >> 63);
    }

    public long timestamp() {
        this.checkTimeBase();
        return (this.mostSigBits & 0xFFFL) << 48 | (this.mostSigBits >> 16 & 0xFFFFL) << 32 | this.mostSigBits >>> 32;
    }

    public int clockSequence() {
        this.checkTimeBase();
        return (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
    }

    public long node() {
        this.checkTimeBase();
        return this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = StrUtil.builder(bl ? 32 : 36);
        stringBuilder.append(UUID.digits(this.mostSigBits >> 32, 8));
        if (!bl) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.digits(this.mostSigBits >> 16, 4));
        if (!bl) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.digits(this.mostSigBits, 4));
        if (!bl) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.digits(this.leastSigBits >> 48, 4));
        if (!bl) {
            stringBuilder.append('-');
        }
        stringBuilder.append(UUID.digits(this.leastSigBits, 12));
        return stringBuilder.toString();
    }

    public int hashCode() {
        long l2 = this.mostSigBits ^ this.leastSigBits;
        return (int)(l2 >> 32) ^ (int)l2;
    }

    public boolean equals(Object object) {
        if (null == object || object.getClass() != UUID.class) {
            return false;
        }
        UUID uUID = (UUID)object;
        return this.mostSigBits == uUID.mostSigBits && this.leastSigBits == uUID.leastSigBits;
    }

    public int compareTo(UUID uUID) {
        int n2 = Long.compare(this.mostSigBits, uUID.mostSigBits);
        if (0 == n2) {
            n2 = Long.compare(this.leastSigBits, uUID.leastSigBits);
        }
        return n2;
    }

    private static String digits(long l2, int n2) {
        long l3 = 1L << n2 * 4;
        return Long.toHexString(l3 | l2 & l3 - 1L).substring(1);
    }

    private void checkTimeBase() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
    }
}

