/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.date.SystemClock;
import com.ccb.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;

public class Snowflake
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long twepoch;
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDataCenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake(long l2, long l3) {
        this(l2, l3, false);
    }

    public Snowflake(long l2, long l3, boolean bl) {
        this(null, l2, l3, bl);
    }

    public Snowflake(Date date, long l2, long l3, boolean bl) {
        this.twepoch = null != date ? date.getTime() : 1288834974657L;
        if (l2 > 31L || l2 < 0L) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"worker Id can't be greater than {} or less than 0", 31L));
        }
        if (l3 > 31L || l3 < 0L) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"datacenter Id can't be greater than {} or less than 0", 31L));
        }
        this.workerId = l2;
        this.dataCenterId = l3;
        this.useSystemClock = bl;
    }

    public long getWorkerId(long l2) {
        return l2 >> 12 & 0x1FL;
    }

    public long getDataCenterId(long l2) {
        return l2 >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long l2) {
        return (l2 >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    public synchronized long nextId() {
        long l2 = this.genTime();
        if (l2 < this.lastTimestamp) {
            if (this.lastTimestamp - l2 < 2000L) {
                l2 = this.lastTimestamp;
            } else {
                throw new IllegalStateException(StrUtil.format((CharSequence)"Clock moved backwards. Refusing to generate id for {}ms", this.lastTimestamp - l2));
            }
        }
        if (l2 == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                l2 = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = l2;
        return l2 - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public String nextIdStr() {
        return Long.toString(this.nextId());
    }

    private long tilNextMillis(long l2) {
        long l3 = this.genTime();
        while (l3 == l2) {
            l3 = this.genTime();
        }
        if (l3 < l2) {
            throw new IllegalStateException(StrUtil.format((CharSequence)"Clock moved backwards. Refusing to generate id for {}ms", l2 - l3));
        }
        return l3;
    }

    private long genTime() {
        return this.useSystemClock ? SystemClock.now() : System.currentTimeMillis();
    }
}

