/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.lang.Range$Steper;
import com.ccb.core.thread.lock.NoLock;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Range
implements Serializable,
Iterable,
Iterator {
    private static final long serialVersionUID = 1L;
    private Lock lock = new ReentrantLock();
    private final Object start;
    private final Object end;
    private Object current;
    private Object next;
    private final Range$Steper steper;
    private int index = 0;
    private final boolean includeStart;
    private boolean includeEnd;

    public Range(Object object, Range$Steper range$Steper) {
        this(object, null, range$Steper);
    }

    public Range(Object object, Object object2, Range$Steper range$Steper) {
        this(object, object2, range$Steper, true, true);
    }

    public Range(Object object, Object object2, Range$Steper range$Steper, boolean bl, boolean bl2) {
        this.start = object;
        this.current = object;
        this.end = object2;
        this.steper = range$Steper;
        this.next = this.safeStep(this.current);
        this.includeStart = bl;
        this.includeEnd = true;
        this.includeEnd = bl2;
    }

    public Range disableLock() {
        this.lock = new NoLock();
        return this;
    }

    @Override
    public boolean hasNext() {
        this.lock.lock();
        try {
            if (0 == this.index && this.includeStart) {
                boolean bl = true;
                return bl;
            }
            if (null == this.next) {
                boolean bl = false;
                return bl;
            }
            if (!this.includeEnd && this.next.equals(this.end)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public Object next() {
        this.lock.lock();
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Has no next range!");
            }
            Object object = this.nextUncheck();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Object nextUncheck() {
        if (0 != this.index || !this.includeStart) {
            this.current = this.next;
            if (null != this.current) {
                this.next = this.safeStep(this.next);
            }
        }
        ++this.index;
        return this.current;
    }

    private Object safeStep(Object object) {
        Object object2 = null;
        try {
            object2 = this.steper.step(object, this.end, this.index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove ranged element!");
    }

    public Iterator iterator() {
        return this;
    }

    public Range reset() {
        this.lock.lock();
        try {
            this.current = this.start;
            this.index = 0;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }
}

