/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ParameterizedTypeImpl
implements Serializable,
ParameterizedType {
    private static final long serialVersionUID = 1L;
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Type rawType;

    public ParameterizedTypeImpl(Type[] typeArray, Type type, Type type2) {
        this.actualTypeArguments = typeArray;
        this.ownerType = type;
        this.rawType = type2;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Type type = this.ownerType;
        Class clazz = (Class)this.rawType;
        if (type == null) {
            stringBuilder.append(clazz.getName());
        } else {
            if (type instanceof Class) {
                stringBuilder.append(((Class)type).getName());
            } else {
                stringBuilder.append(type.toString());
            }
            stringBuilder.append('.').append(clazz.getSimpleName());
        }
        ParameterizedTypeImpl.appendAllTo(stringBuilder.append('<'), ", ", this.actualTypeArguments).append('>');
        return stringBuilder.toString();
    }

    private static StringBuilder appendAllTo(StringBuilder stringBuilder, String string, Type ... typeArray) {
        if (ArrayUtil.isNotEmpty(typeArray)) {
            boolean bl = true;
            for (Type type : typeArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(string);
                }
                String string2 = type instanceof Class ? ((Class)type).getName() : StrUtil.toString(type);
                stringBuilder.append(string2);
            }
        }
        return stringBuilder;
    }
}

