/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.collection.EnumerationIter;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.resource.ResourceUtil;
import com.ccb.core.lang.Filter;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ClassLoaderUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Filter classFilter;
    private final Charset charset;
    private ClassLoader classLoader;
    private boolean initialize;
    private final Set classes = new HashSet();

    public static Set scanPackageByAnnotation(String string, Class clazz) {
        return ClassScanner.scanPackage(string, clazz2 -> clazz2.isAnnotationPresent(clazz));
    }

    public static Set scanPackageBySuper(String string, Class clazz) {
        return ClassScanner.scanPackage(string, clazz2 -> clazz.isAssignableFrom((Class<?>)clazz2) && !clazz.equals(clazz2));
    }

    public static Set scanPackage() {
        return ClassScanner.scanPackage("", null);
    }

    public static Set scanPackage(String string) {
        return ClassScanner.scanPackage(string, null);
    }

    public static Set scanPackage(String string, Filter filter) {
        return new ClassScanner(string, filter).scan();
    }

    public ClassScanner() {
        this(null);
    }

    public ClassScanner(String string) {
        this(string, null);
    }

    public ClassScanner(String string, Filter filter) {
        this(string, filter, CharsetUtil.CHARSET_UTF_8);
    }

    public ClassScanner(String string, Filter filter, Charset charset) {
        this.packageName = string = StrUtil.nullToEmpty(string);
        this.packageNameWithDot = StrUtil.addSuffixIfNot(string, ".");
        this.packageDirName = string.replace('.', File.separatorChar);
        this.packagePath = string.replace('.', '/');
        this.classFilter = filter;
        this.charset = charset;
    }

    public Set scan() {
        for (URL uRL : ResourceUtil.getResourceIter(this.packagePath)) {
            switch (uRL.getProtocol()) {
                case "file": {
                    this.scanFile(new File(URLUtil.decode(uRL.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    this.scanJar(URLUtil.getJarFile(uRL));
                }
            }
        }
        if (CollUtil.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public void setInitialize(boolean bl) {
        this.initialize = bl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void scanJavaClassPaths() {
        String[] stringArray;
        for (String string : stringArray = ClassUtil.getJavaClassPaths()) {
            string = URLUtil.decode(string, CharsetUtil.systemCharsetName());
            this.scanFile(new File(string), null);
        }
    }

    private void scanFile(File file, String string) {
        File[] fileArray;
        if (file.isFile()) {
            String string2 = file.getAbsolutePath();
            if (string2.endsWith(".class")) {
                String string3 = string2.substring(string.length(), string2.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(string3);
            } else if (string2.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException iOException) {
                    throw new IORuntimeException(iOException);
                }
            }
        } else if (file.isDirectory() && null != (fileArray = file.listFiles())) {
            for (File file2 : fileArray) {
                this.scanFile(file2, null == string ? this.subPathBeforePackage(file) : string);
            }
        }
    }

    private void scanJar(JarFile jarFile) {
        for (JarEntry jarEntry : new EnumerationIter(jarFile.entries())) {
            String string = StrUtil.removePrefix(jarEntry.getName(), "/");
            if (!string.startsWith(this.packagePath) || !string.endsWith(".class") || jarEntry.isDirectory()) continue;
            String string2 = string.substring(0, string.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(string2));
        }
    }

    private Class loadClass(String string) {
        ClassLoader classLoader = this.classLoader;
        if (null == classLoader) {
            this.classLoader = classLoader = ClassLoaderUtil.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, this.initialize, classLoader);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return clazz;
    }

    private void addIfAccept(String string) {
        int n2;
        if (StrUtil.isBlank(string)) {
            return;
        }
        int n3 = string.length();
        if (n3 == (n2 = this.packageName.length())) {
            if (string.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(string));
            }
        } else if (n3 > n2 && string.startsWith(this.packageNameWithDot)) {
            this.addIfAccept(this.loadClass(string));
        }
    }

    private void addIfAccept(Class clazz) {
        Filter filter;
        if (null != clazz && ((filter = this.classFilter) == null || filter.accept(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String string = file.getAbsolutePath();
        if (StrUtil.isNotEmpty(this.packageDirName)) {
            string = StrUtil.subBefore((CharSequence)string, this.packageDirName, true);
        }
        return StrUtil.addSuffixIfNot(string, File.separator);
    }
}

