/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.watch.watchers;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.io.watch.Watcher;
import com.ccb.core.lang.Chain;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Iterator;
import java.util.List;

public class WatcherChain
implements Watcher,
Chain {
    private final List chain;

    public static WatcherChain create(Watcher ... watcherArray) {
        return new WatcherChain(watcherArray);
    }

    public WatcherChain(Watcher ... watcherArray) {
        this.chain = CollUtil.newArrayList(watcherArray);
    }

    @Override
    public void onCreate(WatchEvent watchEvent, Path path) {
        for (Watcher watcher : this.chain) {
            watcher.onCreate(watchEvent, path);
        }
    }

    @Override
    public void onModify(WatchEvent watchEvent, Path path) {
        for (Watcher watcher : this.chain) {
            watcher.onModify(watchEvent, path);
        }
    }

    @Override
    public void onDelete(WatchEvent watchEvent, Path path) {
        for (Watcher watcher : this.chain) {
            watcher.onDelete(watchEvent, path);
        }
    }

    @Override
    public void onOverflow(WatchEvent watchEvent, Path path) {
        for (Watcher watcher : this.chain) {
            watcher.onOverflow(watchEvent, path);
        }
    }

    public Iterator iterator() {
        return this.chain.iterator();
    }

    public WatcherChain addChain(Watcher watcher) {
        this.chain.add(watcher);
        return this;
    }
}

