/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.watch.watchers;

import com.ccb.core.collection.ConcurrentHashSet;
import com.ccb.core.io.watch.Watcher;
import com.ccb.core.lang.Assert;
import com.ccb.core.thread.ThreadUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.Set;

public class DelayWatcher
implements Watcher {
    private final Set eventSet = new ConcurrentHashSet();
    private final Watcher watcher;
    private final long delay;

    public DelayWatcher(Watcher watcher, long l2) {
        Assert.notNull(watcher);
        if (watcher instanceof DelayWatcher) {
            throw new IllegalArgumentException("Watcher must not be a DelayWatcher");
        }
        this.watcher = watcher;
        this.delay = l2;
    }

    @Override
    public void onModify(WatchEvent watchEvent, Path path) {
        if (this.delay < 1L) {
            this.watcher.onModify(watchEvent, path);
        } else {
            this.onDelayModify(watchEvent, path);
        }
    }

    @Override
    public void onCreate(WatchEvent watchEvent, Path path) {
        this.watcher.onCreate(watchEvent, path);
    }

    @Override
    public void onDelete(WatchEvent watchEvent, Path path) {
        this.watcher.onDelete(watchEvent, path);
    }

    @Override
    public void onOverflow(WatchEvent watchEvent, Path path) {
        this.watcher.onOverflow(watchEvent, path);
    }

    private void onDelayModify(WatchEvent watchEvent, Path path) {
        Path path2 = Paths.get(path.toString(), watchEvent.context().toString());
        if (this.eventSet.contains(path2)) {
            return;
        }
        this.eventSet.add(path2);
        this.startHandleModifyThread(watchEvent, path);
    }

    private void startHandleModifyThread(WatchEvent watchEvent, Path path) {
        ThreadUtil.execute(() -> {
            ThreadUtil.sleep(this.delay);
            this.eventSet.remove(Paths.get(path.toString(), watchEvent.context().toString()));
            this.watcher.onModify(watchEvent, path);
        });
    }
}

