/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.watch;

import com.ccb.core.io.IoUtil;
import com.ccb.core.io.watch.WatchAction;
import com.ccb.core.io.watch.WatchException;
import com.ccb.core.io.watch.WatchKind;
import com.ccb.core.io.watch.WatchServer$1;
import com.ccb.core.io.watch.Watcher;
import com.ccb.core.lang.Filter;
import com.ccb.core.util.ArrayUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class WatchServer
extends Thread
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private WatchService watchService;
    protected WatchEvent.Kind[] events;
    private WatchEvent.Modifier[] modifiers;
    protected boolean isClosed;
    private final Map watchKeyPathMap = new HashMap();

    public void init() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException iOException) {
            throw new WatchException(iOException);
        }
        this.isClosed = false;
    }

    public void setModifiers(WatchEvent.Modifier[] modifierArray) {
        this.modifiers = modifierArray;
    }

    public void registerPath(Path path, int n2) {
        block3: {
            WatchEvent.Kind[] kindArray = (WatchEvent.Kind[])ArrayUtil.defaultIfEmpty(this.events, WatchKind.ALL);
            try {
                WatchKey watchKey = ArrayUtil.isEmpty(this.modifiers) ? path.register(this.watchService, kindArray) : path.register(this.watchService, kindArray, this.modifiers);
                this.watchKeyPathMap.put(watchKey, path);
                if (n2 > 1) {
                    Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), n2, new WatchServer$1(this));
                }
            }
            catch (IOException iOException) {
                if (iOException instanceof AccessDeniedException) break block3;
                throw new WatchException(iOException);
            }
        }
    }

    public void watch(WatchAction watchAction, Filter filter) {
        WatchKey watchKey;
        try {
            watchKey = this.watchService.take();
        }
        catch (InterruptedException | ClosedWatchServiceException exception) {
            this.close();
            return;
        }
        Path path = (Path)this.watchKeyPathMap.get(watchKey);
        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
            if (null != filter && !filter.accept(watchEvent)) continue;
            watchAction.doAction(watchEvent, path);
        }
        watchKey.reset();
    }

    public void watch(Watcher watcher, Filter filter) {
        this.watch((WatchEvent watchEvent, Path path) -> {
            WatchEvent.Kind kind = watchEvent.kind();
            if (kind == WatchKind.CREATE.getValue()) {
                watcher.onCreate(watchEvent, path);
            } else if (kind == WatchKind.MODIFY.getValue()) {
                watcher.onModify(watchEvent, path);
            } else if (kind == WatchKind.DELETE.getValue()) {
                watcher.onDelete(watchEvent, path);
            } else if (kind == WatchKind.OVERFLOW.getValue()) {
                watcher.onOverflow(watchEvent, path);
            }
        }, filter);
    }

    @Override
    public void close() {
        this.isClosed = true;
        IoUtil.close(this.watchService);
    }
}

