/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.watch;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.watch.WatchException;
import com.ccb.core.io.watch.WatchKind;
import com.ccb.core.io.watch.WatchServer;
import com.ccb.core.io.watch.Watcher;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.FileAttribute;

public class WatchMonitor
extends WatchServer {
    private static final long serialVersionUID = 1L;
    public static final WatchEvent.Kind OVERFLOW = WatchKind.OVERFLOW.getValue();
    public static final WatchEvent.Kind ENTRY_MODIFY = WatchKind.MODIFY.getValue();
    public static final WatchEvent.Kind ENTRY_CREATE = WatchKind.CREATE.getValue();
    public static final WatchEvent.Kind ENTRY_DELETE = WatchKind.DELETE.getValue();
    public static final WatchEvent.Kind[] EVENTS_ALL = WatchKind.ALL;
    private Path path;
    private int maxDepth;
    private Path filePath;
    private Watcher watcher;

    public static WatchMonitor create(URL uRL, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(uRL, 0, kindArray);
    }

    public static WatchMonitor create(URL uRL, int n2, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(URLUtil.toURI(uRL), n2, kindArray);
    }

    public static WatchMonitor create(URI uRI, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(uRI, 0, kindArray);
    }

    public static WatchMonitor create(URI uRI, int n2, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(Paths.get(uRI), n2, kindArray);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(file, 0, kindArray);
    }

    public static WatchMonitor create(File file, int n2, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(file.toPath(), n2, kindArray);
    }

    public static WatchMonitor create(String string, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(string, 0, kindArray);
    }

    public static WatchMonitor create(String string, int n2, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(Paths.get(string, new String[0]), n2, kindArray);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind ... kindArray) {
        return WatchMonitor.create(path, 0, kindArray);
    }

    public static WatchMonitor create(Path path, int n2, WatchEvent.Kind ... kindArray) {
        return new WatchMonitor(path, n2, kindArray);
    }

    public static WatchMonitor createAll(URI uRI, Watcher watcher) {
        return WatchMonitor.createAll(Paths.get(uRI), watcher);
    }

    public static WatchMonitor createAll(URL uRL, Watcher watcher) {
        try {
            return WatchMonitor.createAll(Paths.get(uRL.toURI()), watcher);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WatchException(uRISyntaxException);
        }
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchMonitor.createAll(file.toPath(), watcher);
    }

    public static WatchMonitor createAll(String string, Watcher watcher) {
        return WatchMonitor.createAll(Paths.get(string, new String[0]), watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        WatchMonitor watchMonitor = WatchMonitor.create(path, EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public WatchMonitor(File file, WatchEvent.Kind ... kindArray) {
        this(file.toPath(), kindArray);
    }

    public WatchMonitor(String string, WatchEvent.Kind ... kindArray) {
        this(Paths.get(string, new String[0]), kindArray);
    }

    public WatchMonitor(Path path, WatchEvent.Kind ... kindArray) {
        this(path, 0, kindArray);
    }

    public WatchMonitor(Path path, int n2, WatchEvent.Kind ... kindArray) {
        this.path = path;
        this.maxDepth = n2;
        this.events = kindArray;
        this.init();
    }

    @Override
    public void init() {
        if (!Files.exists(this.path, LinkOption.NOFOLLOW_LINKS)) {
            String string;
            Path path = FileUtil.getLastPathEle(this.path);
            if (null != path && StrUtil.contains((CharSequence)(string = path.toString()), '.') && !StrUtil.endWithIgnoreCase(string, ".d")) {
                this.filePath = this.path;
                this.path = this.filePath.getParent();
            }
            try {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new IORuntimeException(iOException);
            }
        } else if (Files.isRegularFile(this.path, LinkOption.NOFOLLOW_LINKS)) {
            this.filePath = this.path;
            this.path = this.filePath.getParent();
        }
        super.init();
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) {
        if (this.isClosed) {
            throw new WatchException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.isClosed) {
            this.doTakeAndWatch(watcher);
        }
    }

    public WatchMonitor setMaxDepth(int n2) {
        this.maxDepth = n2;
        return this;
    }

    private void doTakeAndWatch(Watcher watcher) {
        super.watch(watcher, (Object watchEvent) -> null == this.filePath || this.filePath.endsWith(watchEvent.context().toString()));
    }

    private void registerPath() {
        this.registerPath(this.path, null != this.filePath ? 0 : this.maxDepth);
    }
}

