/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.resource;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.collection.EnumerationIter;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.resource.ClassPathResource;
import com.ccb.core.io.resource.FileResource;
import com.ccb.core.io.resource.NoResourceException;
import com.ccb.core.io.resource.Resource;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ClassLoaderUtil;
import com.ccb.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;

public class ResourceUtil {
    public static String readUtf8Str(String string) {
        return ResourceUtil.getResourceObj(string).readUtf8Str();
    }

    public static String readStr(String string, Charset charset) {
        return ResourceUtil.getResourceObj(string).readStr(charset);
    }

    public static byte[] readBytes(String string) {
        return ResourceUtil.getResourceObj(string).readBytes();
    }

    public static InputStream getStream(String string) {
        return ResourceUtil.getResourceObj(string).getStream();
    }

    public static InputStream getStreamSafe(String string) {
        try {
            return ResourceUtil.getResourceObj(string).getStream();
        }
        catch (NoResourceException noResourceException) {
            return null;
        }
    }

    public static BufferedReader getUtf8Reader(String string) {
        return ResourceUtil.getReader(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(String string, Charset charset) {
        return ResourceUtil.getResourceObj(string).getReader(charset);
    }

    public static URL getResource(String string) {
        return ResourceUtil.getResource(string, null);
    }

    public static List getResources(String string) {
        Enumeration<URL> enumeration;
        try {
            enumeration = ClassLoaderUtil.getClassLoader().getResources(string);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return CollUtil.newArrayList(enumeration);
    }

    public static EnumerationIter getResourceIter(String string) {
        Enumeration<URL> enumeration;
        try {
            enumeration = ClassLoaderUtil.getClassLoader().getResources(string);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return new EnumerationIter(enumeration);
    }

    public static URL getResource(String string, Class clazz) {
        return null != clazz ? clazz.getResource(string) : ClassLoaderUtil.getClassLoader().getResource(string);
    }

    public static Resource getResourceObj(String string) {
        if (StrUtil.isNotBlank(string) && (string.startsWith("file:") || FileUtil.isAbsolutePath(string))) {
            return new FileResource(string);
        }
        return new ClassPathResource(string);
    }
}

