/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.resource;

import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;

public interface Resource {
    public String getName();

    public URL getUrl();

    public InputStream getStream();

    default public void writeTo(OutputStream outputStream) {
        try (InputStream inputStream = this.getStream();){
            IoUtil.copy(inputStream, outputStream);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public BufferedReader getReader(Charset var1);

    public String readStr(Charset var1);

    default public String readUtf8Str() {
        return this.readStr(CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] readBytes();
}

