/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.file;

import com.ccb.core.date.DateUnit;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.LineHandler;
import com.ccb.core.io.file.FileMode;
import com.ccb.core.io.file.LineReadWatcher;
import com.ccb.core.io.file.Tailer$ConsoleLineHandler;
import com.ccb.core.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Tailer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final LineHandler CONSOLE_HANDLER = new Tailer$ConsoleLineHandler();
    private final Charset charset;
    private final LineHandler lineHandler;
    private final int initReadLine;
    private final long period;
    private final RandomAccessFile randomAccessFile;
    private final ScheduledExecutorService executorService;

    public Tailer(File file, LineHandler lineHandler) {
        this(file, lineHandler, 0);
    }

    public Tailer(File file, LineHandler lineHandler, int n2) {
        this(file, CharsetUtil.CHARSET_UTF_8, lineHandler, n2, DateUnit.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, LineHandler lineHandler) {
        this(file, charset, lineHandler, 0, DateUnit.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, LineHandler lineHandler, int n2, long l2) {
        Tailer.checkFile(file);
        this.charset = charset;
        this.lineHandler = lineHandler;
        this.period = l2;
        this.initReadLine = n2;
        this.randomAccessFile = FileUtil.createRandomAccessFile(file, FileMode.r);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean bl) {
        try {
            this.readTail();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        LineReadWatcher lineReadWatcher = new LineReadWatcher(this.randomAccessFile, this.charset, this.lineHandler);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(lineReadWatcher, 0L, this.period, TimeUnit.MILLISECONDS);
        if (!bl) {
            try {
                scheduledFuture.get();
            }
            catch (ExecutionException executionException) {
                throw new UtilException(executionException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void readTail() {
        long l2 = this.randomAccessFile.length();
        if (this.initReadLine > 0) {
            Stack<String> stack = new Stack<String>();
            long l3 = this.randomAccessFile.getFilePointer();
            long l4 = l2 - 1L;
            this.randomAccessFile.seek(l4);
            int n2 = 0;
            while (l4 > l3 && n2 <= this.initReadLine) {
                String string;
                int n3 = this.randomAccessFile.read();
                if (n3 == 10 || n3 == 13) {
                    string = FileUtil.readLine(this.randomAccessFile, this.charset);
                    if (null != string) {
                        stack.push(string);
                    }
                    ++n2;
                    --l4;
                }
                this.randomAccessFile.seek(--l4);
                if (l4 != 0L) continue;
                string = FileUtil.readLine(this.randomAccessFile, this.charset);
                if (null == string) break;
                stack.push(string);
                break;
            }
            while (!stack.isEmpty()) {
                this.lineHandler.handle((String)stack.pop());
            }
        }
        try {
            this.randomAccessFile.seek(l2);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new UtilException("File [{}] not exist !", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("Path [{}] is not a file !", file.getAbsolutePath());
        }
    }
}

