/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.file;

import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.file.PathUtil$1;
import com.ccb.core.io.file.PathUtil$2;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.CharsetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PathUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl = false == directoryStream.iterator().hasNext();
            return bl;
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static List loopFiles(Path path, int n2, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (null == path || !Files.exists(path, new LinkOption[0])) {
            return arrayList;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            File file = path.toFile();
            if (null == fileFilter || fileFilter.accept(file)) {
                arrayList.add(file);
            }
            return arrayList;
        }
        PathUtil.walkFiles(path, n2, new PathUtil$1(fileFilter, arrayList));
        return arrayList;
    }

    public static void walkFiles(Path path, int n2, FileVisitor fileVisitor) {
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        try {
            Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), n2, fileVisitor);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static boolean del(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, new PathUtil$2());
            } else {
                Files.delete(path);
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return true;
    }

    public static Path copyFile(Path path, Path path2, StandardCopyOption ... standardCopyOptionArray) {
        return PathUtil.copyFile(path, path2, (CopyOption[])standardCopyOptionArray);
    }

    public static Path copyFile(Path path, Path path2, CopyOption ... copyOptionArray) {
        Assert.notNull(path, "Source File is null !", new Object[0]);
        Assert.notNull(path2, "Destination File or directiory is null !", new Object[0]);
        Path path3 = path2.toFile().isDirectory() ? path2.resolve(path.getFileName()) : path2;
        try {
            return Files.copy(path, path3, copyOptionArray);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static boolean isDirectory(Path path, boolean bl) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (bl) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptionArray3 = linkOptionArray;
        return Files.isDirectory(path, linkOptionArray3);
    }

    public static Path getPathEle(Path path, int n2) {
        return PathUtil.subPath(path, n2, n2 == -1 ? path.getNameCount() : n2 + 1);
    }

    public static Path getLastPathEle(Path path) {
        return PathUtil.getPathEle(path, path.getNameCount() - 1);
    }

    public static Path subPath(Path path, int n2, int n3) {
        if (null == path) {
            return null;
        }
        int n4 = path.getNameCount();
        if (n2 < 0) {
            if ((n2 = n4 + n2) < 0) {
                n2 = 0;
            }
        } else if (n2 > n4) {
            n2 = n4;
        }
        if (n3 < 0) {
            if ((n3 = n4 + n3) < 0) {
                n3 = n4;
            }
        } else if (n3 > n4) {
            n3 = n4;
        }
        if (n3 < n2) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n2 == n3) {
            return null;
        }
        return path.subpath(n2, n3);
    }

    public static BasicFileAttributes getAttributes(Path path, boolean bl) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return null;
        }
        if (bl) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptionArray3 = linkOptionArray;
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, linkOptionArray3);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static BufferedInputStream getInputStream(Path path) {
        InputStream inputStream;
        try {
            inputStream = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return IoUtil.toBuffered(inputStream);
    }

    public static BufferedReader getUtf8Reader(Path path) {
        return PathUtil.getReader(path, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(Path path, Charset charset) {
        return IoUtil.getReader((InputStream)PathUtil.getInputStream(path), charset);
    }

    public static BufferedOutputStream getOutputStream(Path path) {
        OutputStream outputStream;
        try {
            outputStream = Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return IoUtil.toBuffered(outputStream);
    }

    public static Path rename(Path path, String string, boolean bl) {
        CopyOption[] copyOptionArray;
        if (bl) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] copyOptionArray3 = copyOptionArray;
        try {
            return Files.move(path, path.resolveSibling(string), copyOptionArray3);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static boolean equals(Path path, Path path2) {
        try {
            return Files.isSameFile(path, path2);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static boolean isFile(Path path, boolean bl) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (bl) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptionArray3 = linkOptionArray;
        return Files.isRegularFile(path, linkOptionArray3);
    }

    public static boolean isSymlink(Path path) {
        return Files.isSymbolicLink(path);
    }
}

