/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.file;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.LineHandler;
import com.ccb.core.io.watch.SimpleWatcher;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;

public class LineReadWatcher
extends SimpleWatcher
implements Runnable {
    private final RandomAccessFile randomAccessFile;
    private final Charset charset;
    private final LineHandler lineHandler;

    public LineReadWatcher(RandomAccessFile randomAccessFile, Charset charset, LineHandler lineHandler) {
        this.randomAccessFile = randomAccessFile;
        this.charset = charset;
        this.lineHandler = lineHandler;
    }

    @Override
    public void run() {
        this.onModify(null, null);
    }

    @Override
    public void onModify(WatchEvent watchEvent, Path path) {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        Charset charset = this.charset;
        LineHandler lineHandler = this.lineHandler;
        try {
            long l2 = randomAccessFile.length();
            long l3 = randomAccessFile.getFilePointer();
            if (0L == l2 || l3 == l2) {
                return;
            }
            if (l2 < l3) {
                randomAccessFile.seek(l2);
                return;
            }
            FileUtil.readLines(randomAccessFile, charset, lineHandler);
            randomAccessFile.seek(l2);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }
}

