/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io;

import com.ccb.core.io.FastByteBuffer;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.util.CharsetUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class FastByteArrayOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int n2) {
        this.buffer = new FastByteBuffer(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.buffer.append(byArray, n2, n3);
    }

    @Override
    public void write(int n2) {
        this.buffer.append((byte)n2);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.buffer.reset();
    }

    public void writeTo(OutputStream outputStream) {
        int n2 = this.buffer.index();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                byte[] byArray = this.buffer.array(i2);
                outputStream.write(byArray);
            }
            outputStream.write(this.buffer.array(n2), 0, this.buffer.offset());
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String string) {
        return this.toString(CharsetUtil.charset(string));
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), charset);
    }
}

