/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img.gif;

public class NeuQuant {
    protected static final int NETSIZE = 256;
    protected static final int PRIME1 = 499;
    protected static final int PRIME2 = 491;
    protected static final int PRIME3 = 487;
    protected static final int PRIME4 = 503;
    protected static final int MINPICTUREBYTES = 1509;
    protected static final int MAXNETPOS = 255;
    protected static final int NETBIASSHIFT = 4;
    protected static final int NCYCLES = 100;
    protected static final int INTBIASSHIFT = 16;
    protected static final int INTBIAS = 65536;
    protected static final int GAMMASHIFT = 10;
    protected static final int GAMMA = 1024;
    protected static final int BETASHIFT = 10;
    protected static final int BETA = 64;
    protected static final int BETAGAMMA = 65536;
    protected static final int INITRAD = 32;
    protected static final int RADIUSBIASSHIFT = 6;
    protected static final int RADIUSBIAS = 64;
    protected static final int INITRADIUS = 2048;
    protected static final int RADIUSDEC = 30;
    protected static final int ALPHABIASSHIFT = 10;
    protected static final int INITALPHA = 1024;
    protected int alphadec;
    protected static final int RADBIASSHIFT = 8;
    protected static final int RADBIAS = 256;
    protected static final int ALPHARADBSHIFT = 18;
    protected static final int ALPHARADBIAS = 262144;
    protected byte[] thepicture;
    protected int lengthcount;
    protected int samplefac;
    protected int[][] network;
    protected int[] netindex = new int[256];
    protected int[] bias = new int[256];
    protected int[] freq = new int[256];
    protected int[] radpower = new int[32];

    public NeuQuant(byte[] byArray, int n2, int n3) {
        this.thepicture = byArray;
        this.lengthcount = n2;
        this.samplefac = n3;
        this.network = new int[256][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.network[i2] = new int[4];
            int[] nArray = this.network[i2];
            nArray[1] = nArray[2] = (i2 << 12) / 256;
            nArray[0] = nArray[2];
            this.freq[i2] = 256;
            this.bias[i2] = 0;
        }
    }

    public byte[] colorMap() {
        int n2;
        byte[] byArray = new byte[768];
        int[] nArray = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            nArray[this.network[n2][3]] = n2;
        }
        n2 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            int n3 = nArray[i2];
            byArray[n2++] = (byte)this.network[n3][0];
            byArray[n2++] = (byte)this.network[n3][1];
            byArray[n2++] = (byte)this.network[n3][2];
        }
        return byArray;
    }

    public void inxbuild() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            int[] nArray;
            int[] nArray2 = this.network[i2];
            int n5 = i2;
            int n6 = nArray2[1];
            for (n2 = i2 + 1; n2 < 256; ++n2) {
                nArray = this.network[n2];
                if (nArray[1] >= n6) continue;
                n5 = n2;
                n6 = nArray[1];
            }
            nArray = this.network[n5];
            if (i2 != n5) {
                n2 = nArray[0];
                nArray[0] = nArray2[0];
                nArray2[0] = n2;
                n2 = nArray[1];
                nArray[1] = nArray2[1];
                nArray2[1] = n2;
                n2 = nArray[2];
                nArray[2] = nArray2[2];
                nArray2[2] = n2;
                n2 = nArray[3];
                nArray[3] = nArray2[3];
                nArray2[3] = n2;
            }
            if (n6 == n3) continue;
            this.netindex[n3] = n4 + i2 >> 1;
            for (n2 = n3 + 1; n2 < n6; ++n2) {
                this.netindex[n2] = i2;
            }
            n3 = n6;
            n4 = i2;
        }
        this.netindex[n3] = n4 + 255 >> 1;
        for (n2 = n3 + 1; n2 < 256; ++n2) {
            this.netindex[n2] = 255;
        }
    }

    public void learn() {
        int n2;
        if (this.lengthcount < 1509) {
            this.samplefac = 1;
        }
        this.alphadec = 30 + (this.samplefac - 1) / 3;
        byte[] byArray = this.thepicture;
        int n3 = 0;
        int n4 = this.lengthcount;
        int n5 = this.lengthcount / (3 * this.samplefac);
        int n6 = n5 / 100;
        int n7 = 1024;
        int n8 = 2048;
        int n9 = n8 >> 6;
        for (n2 = 0; n2 < n9; ++n2) {
            this.radpower[n2] = n7 * ((n9 * n9 - n2 * n2) * 256 / (n9 * n9));
        }
        int n10 = this.lengthcount < 1509 ? 3 : (this.lengthcount % 499 != 0 ? 1497 : (this.lengthcount % 491 != 0 ? 1473 : (this.lengthcount % 487 != 0 ? 1461 : 1509)));
        n2 = 0;
        while (n2 < n5) {
            int n11 = (byArray[n3] & 0xFF) << 4;
            int n12 = (byArray[n3 + 1] & 0xFF) << 4;
            int n13 = (byArray[n3 + 2] & 0xFF) << 4;
            int n14 = this.contest(n11, n12, n13);
            this.altersingle(n7, n14, n11, n12, n13);
            if (n9 != 0) {
                this.alterneigh(n9, n14, n11, n12, n13);
            }
            if ((n3 += n10) >= n4) {
                n3 -= this.lengthcount;
            }
            ++n2;
            if (n6 == 0) {
                n6 = 1;
            }
            if (n2 % n6 != 0) continue;
            n7 -= n7 / this.alphadec;
            if ((n9 = (n8 -= n8 / 30) >> 6) <= 1) {
                n9 = 0;
            }
            for (n14 = 0; n14 < n9; ++n14) {
                this.radpower[n14] = n7 * ((n9 * n9 - n14 * n14) * 256 / (n9 * n9));
            }
        }
    }

    public int map(int n2, int n3, int n4) {
        int n5 = 1000;
        int n6 = -1;
        int n7 = this.netindex[n3];
        int n8 = n7 - 1;
        while (n7 < 256 || n8 >= 0) {
            int n9;
            int n10;
            int[] nArray;
            if (n7 < 256) {
                nArray = this.network[n7];
                n10 = nArray[1] - n3;
                if (n10 >= n5) {
                    n7 = 256;
                } else {
                    ++n7;
                    if (n10 < 0) {
                        n10 = -n10;
                    }
                    if ((n9 = nArray[0] - n2) < 0) {
                        n9 = -n9;
                    }
                    if ((n10 += n9) < n5) {
                        n9 = nArray[2] - n4;
                        if (n9 < 0) {
                            n9 = -n9;
                        }
                        if ((n10 += n9) < n5) {
                            n5 = n10;
                            n6 = nArray[3];
                        }
                    }
                }
            }
            if (n8 < 0) continue;
            nArray = this.network[n8];
            n10 = n3 - nArray[1];
            if (n10 >= n5) {
                n8 = -1;
                continue;
            }
            --n8;
            if (n10 < 0) {
                n10 = -n10;
            }
            if ((n9 = nArray[0] - n2) < 0) {
                n9 = -n9;
            }
            if ((n10 += n9) >= n5) continue;
            n9 = nArray[2] - n4;
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n10 += n9) >= n5) continue;
            n5 = n10;
            n6 = nArray[3];
        }
        return n6;
    }

    public byte[] process() {
        this.learn();
        this.unbiasnet();
        this.inxbuild();
        return this.colorMap();
    }

    public void unbiasnet() {
        for (int i2 = 0; i2 < 256; ++i2) {
            int[] nArray = this.network[i2];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[i2];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[i2];
            nArray3[2] = nArray3[2] >> 4;
            this.network[i2][3] = i2;
        }
    }

    protected void alterneigh(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n3 - n2;
        if (n8 < -1) {
            n8 = -1;
        }
        if ((n7 = n3 + n2) > 256) {
            n7 = 256;
        }
        int n9 = n3 + 1;
        int n10 = n3 - 1;
        int n11 = 1;
        while (n9 < n7 || n10 > n8) {
            int[] nArray;
            int n12 = this.radpower[n11++];
            if (n9 < n7) {
                nArray = this.network[n9++];
                try {
                    nArray[0] = nArray[0] - n12 * (nArray[0] - n4) / 262144;
                    nArray[1] = nArray[1] - n12 * (nArray[1] - n5) / 262144;
                    nArray[2] = nArray[2] - n12 * (nArray[2] - n6) / 262144;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n10 <= n8) continue;
            nArray = this.network[n10--];
            try {
                nArray[0] = nArray[0] - n12 * (nArray[0] - n4) / 262144;
                nArray[1] = nArray[1] - n12 * (nArray[1] - n5) / 262144;
                nArray[2] = nArray[2] - n12 * (nArray[2] - n6) / 262144;
            }
            catch (Exception exception) {}
        }
    }

    protected void altersingle(int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = this.network[n3];
        nArray[0] = nArray[0] - n2 * (nArray[0] - n4) / 1024;
        nArray[1] = nArray[1] - n2 * (nArray[1] - n5) / 1024;
        nArray[2] = nArray[2] - n2 * (nArray[2] - n6) / 1024;
    }

    protected int contest(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n6 = Integer.MAX_VALUE;
        int n8 = n5 = -1;
        int n9 = 0;
        while (n9 < 256) {
            int n10;
            int n11;
            int[] nArray = this.network[n9];
            int n12 = nArray[0] - n2;
            if (n12 < 0) {
                n12 = -n12;
            }
            if ((n11 = nArray[1] - n3) < 0) {
                n11 = -n11;
            }
            n12 += n11;
            n11 = nArray[2] - n4;
            if (n11 < 0) {
                n11 = -n11;
            }
            if ((n12 += n11) < n6) {
                n6 = n12;
                n5 = n9;
            }
            if ((n10 = n12 - (this.bias[n9] >> 12)) < n7) {
                n7 = n10;
                n8 = n9;
            }
            int n13 = this.freq[n9] >> 10;
            int n14 = n9;
            this.freq[n14] = this.freq[n14] - n13;
            int n15 = n9++;
            this.bias[n15] = this.bias[n15] + (n13 << 10);
        }
        int n16 = n5;
        this.freq[n16] = this.freq[n16] + 64;
        int n17 = n5;
        this.bias[n17] = this.bias[n17] - 65536;
        return n8;
    }
}

