/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img.gif;

import com.ccb.core.img.gif.GifDecoder$GifFrame;
import com.ccb.core.io.IoUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class GifDecoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected BufferedInputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected Rectangle lastRect;
    protected BufferedImage image;
    protected BufferedImage lastImage;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected int lastDispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MAX_STACK_SIZE = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected ArrayList frames;
    protected int frameCount;

    public int getDelay(int n2) {
        this.delay = -1;
        if (n2 >= 0 && n2 < this.frameCount) {
            this.delay = ((GifDecoder$GifFrame)this.frames.get((int)n2)).delay;
        }
        return this.delay;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public BufferedImage getImage() {
        return this.getFrame(0);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    protected void setPixels() {
        int n2;
        int[] nArray = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                n2 = this.frameCount - 2;
                this.lastImage = n2 > 0 ? this.getFrame(n2 - 1) : null;
            }
            if (this.lastImage != null) {
                int[] nArray2 = ((DataBufferInt)this.lastImage.getRaster().getDataBuffer()).getData();
                System.arraycopy(nArray2, 0, nArray, 0, this.width * this.height);
                if (this.lastDispose == 2) {
                    Graphics2D graphics2D = this.image.createGraphics();
                    Color color = this.transparency ? new Color(0, 0, 0, 0) : new Color(this.lastBgColor);
                    graphics2D.setColor(color);
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.fill(this.lastRect);
                    graphics2D.dispose();
                }
            }
        }
        n2 = 1;
        int n3 = 8;
        int n4 = 0;
        for (int i2 = 0; i2 < this.ih; ++i2) {
            int n5 = i2;
            if (this.interlace) {
                if (n4 >= this.ih) {
                    switch (++n2) {
                        case 2: {
                            n4 = 4;
                            break;
                        }
                        case 3: {
                            n4 = 2;
                            n3 = 4;
                            break;
                        }
                        case 4: {
                            n4 = 1;
                            n3 = 2;
                        }
                    }
                }
                n5 = n4;
                n4 += n3;
            }
            if ((n5 += this.iy) >= this.height) continue;
            int n6 = n5 * this.width;
            int n7 = n6 + this.ix;
            int n8 = n7 + this.iw;
            if (n6 + this.width < n8) {
                n8 = n6 + this.width;
            }
            int n9 = i2 * this.iw;
            while (n7 < n8) {
                int n10;
                int n11;
                if ((n11 = this.act[n10 = this.pixels[n9++] & 0xFF]) != 0) {
                    nArray[n7] = n11;
                }
                ++n7;
            }
        }
    }

    public BufferedImage getFrame(int n2) {
        BufferedImage bufferedImage = null;
        if (n2 >= 0 && n2 < this.frameCount) {
            bufferedImage = ((GifDecoder$GifFrame)this.frames.get((int)n2)).image;
        }
        return bufferedImage;
    }

    public Dimension getFrameSize() {
        return new Dimension(this.width, this.height);
    }

    public int read(BufferedInputStream bufferedInputStream) {
        this.init();
        if (bufferedInputStream != null) {
            this.in = bufferedInputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        IoUtil.close(bufferedInputStream);
        return this.status;
    }

    public int read(InputStream inputStream) {
        this.init();
        if (inputStream != null) {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            this.in = (BufferedInputStream)inputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        IoUtil.close(inputStream);
        return this.status;
    }

    public int read(String string) {
        this.status = 0;
        try {
            string = string.trim().toLowerCase();
            if (string.contains("file:") || string.indexOf(":/") > 0) {
                URL uRL = new URL(string);
                this.in = new BufferedInputStream(uRL.openStream());
            } else {
                this.in = new BufferedInputStream(new FileInputStream(string));
            }
            this.status = this.read(this.in);
        }
        catch (IOException iOException) {
            this.status = 2;
        }
        return this.status;
    }

    protected void decodeImageData() {
        int n2;
        int n3 = -1;
        int n4 = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < n4) {
            this.pixels = new byte[n4];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n5 = this.read();
        int n6 = 1 << n5;
        int n7 = n6 + 1;
        int n8 = n6 + 2;
        int n9 = n3;
        int n10 = n5 + 1;
        int n11 = (1 << n10) - 1;
        for (n2 = 0; n2 < n6; ++n2) {
            this.prefix[n2] = 0;
            this.suffix[n2] = (byte)n2;
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        while (n19 < n4) {
            if (n14 == 0) {
                if (n17 < n10) {
                    if (n16 == 0) {
                        n16 = this.readBlock();
                        if (n16 <= 0) break;
                        n12 = 0;
                    }
                    n18 += (this.block[n12] & 0xFF) << n17;
                    n17 += 8;
                    ++n12;
                    --n16;
                    continue;
                }
                n2 = n18 & n11;
                n18 >>= n10;
                n17 -= n10;
                if (n2 > n8 || n2 == n7) break;
                if (n2 == n6) {
                    n10 = n5 + 1;
                    n11 = (1 << n10) - 1;
                    n8 = n6 + 2;
                    n9 = n3;
                    continue;
                }
                if (n9 == n3) {
                    this.pixelStack[n14++] = this.suffix[n2];
                    n9 = n2;
                    n15 = n2;
                    continue;
                }
                int n20 = n2;
                if (n2 == n8) {
                    this.pixelStack[n14++] = (byte)n15;
                    n2 = n9;
                }
                while (n2 > n6) {
                    this.pixelStack[n14++] = this.suffix[n2];
                    n2 = this.prefix[n2];
                }
                n15 = this.suffix[n2] & 0xFF;
                if (n8 >= 4096) {
                    this.pixelStack[n14++] = (byte)n15;
                    continue;
                }
                this.pixelStack[n14++] = (byte)n15;
                this.prefix[n8] = (short)n9;
                this.suffix[n8] = (byte)n15;
                if ((++n8 & n11) == 0 && n8 < 4096) {
                    ++n10;
                    n11 += n8;
                }
                n9 = n20;
            }
            this.pixels[n13++] = this.pixelStack[--n14];
            ++n19;
        }
        for (n19 = n13; n19 < n4; ++n19) {
            this.pixels[n19] = 0;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new ArrayList();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int n2 = 0;
        try {
            n2 = this.in.read();
        }
        catch (IOException iOException) {
            this.status = 1;
        }
        return n2;
    }

    protected int readBlock() {
        int n2;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int n3;
                for (n2 = 0; n2 < this.blockSize && (n3 = this.in.read(this.block, n2, this.blockSize - n2)) != -1; n2 += n3) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n2 < this.blockSize) {
                this.status = 1;
            }
        }
        return n2;
    }

    protected int[] readColorTable(int n2) {
        int n3 = 3 * n2;
        int[] nArray = null;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        try {
            n4 = this.in.read(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n4 < n3) {
            this.status = 1;
        } else {
            nArray = new int[256];
            int n5 = 0;
            int n6 = 0;
            while (n5 < n2) {
                int n7 = byArray[n6++] & 0xFF;
                int n8 = byArray[n6++] & 0xFF;
                int n9 = byArray[n6++] & 0xFF;
                nArray[n5++] = 0xFF000000 | n7 << 16 | n8 << 8 | n9;
            }
        }
        return nArray;
    }

    protected void readContents() {
        boolean bl = false;
        while (!bl && !this.err()) {
            int n2 = this.read();
            block0 : switch (n2) {
                case 44: {
                    this.readImage();
                    break;
                }
                case 33: {
                    n2 = this.read();
                    switch (n2) {
                        case 249: {
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i2 = 0; i2 < 11; ++i2) {
                                stringBuilder.append((char)this.block[i2]);
                            }
                            if ("NETSCAPE2.0".equals(stringBuilder.toString())) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    bl = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.status = 1;
                }
            }
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int n2 = this.read();
        this.dispose = (n2 & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n2 & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 6; ++i2) {
            stringBuilder.append((char)this.read());
        }
        if (!stringBuilder.toString().startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n2 = this.read();
        this.lctFlag = (n2 & 0x80) != 0;
        this.interlace = (n2 & 0x40) != 0;
        this.lctSize = 2 << (n2 & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int n3 = 0;
        if (this.transparency) {
            n3 = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        this.image = new BufferedImage(this.width, this.height, 3);
        this.setPixels();
        this.frames.add(new GifDecoder$GifFrame(this.image, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = n3;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int n2 = this.read();
        this.gctFlag = (n2 & 0x80) != 0;
        this.gctSize = 2 << (n2 & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n2 = this.block[1] & 0xFF;
            int n3 = this.block[2] & 0xFF;
            this.loopCount = n3 << 8 | n2;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lastRect = new Rectangle(this.ix, this.iy, this.iw, this.ih);
        this.lastImage = this.image;
        this.lastBgColor = this.bgColor;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }
}

