/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img;

import com.ccb.core.img.FontUtil;
import com.ccb.core.img.ImgUtil;
import com.ccb.core.util.ObjectUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class GraphicsUtil {
    public static Graphics2D createGraphics(BufferedImage bufferedImage, Color color) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (null != color) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        return graphics2D;
    }

    public static int getCenterY(Graphics graphics, int n2) {
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = graphics.getFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = null != fontMetrics ? (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() : n2 / 3;
        return n3;
    }

    public static Graphics drawStringColourful(Graphics graphics, String string, Font font, int n2, int n3) {
        return GraphicsUtil.drawString(graphics, string, font, null, n2, n3);
    }

    public static Graphics drawString(Graphics graphics, String string, Font font, Color color, int n2, int n3) {
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setFont(font);
        int n4 = GraphicsUtil.getCenterY(graphics, n3);
        if (null != color) {
            graphics.setColor(color);
        }
        int n5 = string.length();
        int n6 = n2 / n5;
        for (int i2 = 0; i2 < n5; ++i2) {
            if (null == color) {
                graphics.setColor(ImgUtil.randomColor());
            }
            graphics.drawString(String.valueOf(string.charAt(i2)), i2 * n6, n4);
        }
        return graphics;
    }

    public static Graphics drawString(Graphics graphics, String string, Font font, Color color, Rectangle rectangle) {
        Dimension dimension;
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        try {
            dimension = FontUtil.getDimension(graphics.getFontMetrics(font), string);
        }
        catch (Exception exception) {
            dimension = new Dimension(n2 / 3, n3 / 3);
        }
        rectangle.setSize(dimension.width, dimension.height);
        Point point = ImgUtil.getPointBaseCentre(rectangle, n2, n3);
        return GraphicsUtil.drawString(graphics, string, font, color, point);
    }

    public static Graphics drawString(Graphics graphics, String string, Font font, Color color, Point point) {
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setFont(font);
        graphics.setColor((Color)ObjectUtil.defaultIfNull(color, Color.BLACK));
        graphics.drawString(string, point.x, point.y);
        return graphics;
    }

    public static Graphics drawImg(Graphics graphics, Image image, Point point) {
        return GraphicsUtil.drawImg(graphics, image, new Rectangle(point.x, point.y, image.getWidth(null), image.getHeight(null)));
    }

    public static Graphics drawImg(Graphics graphics, Image image, Rectangle rectangle) {
        graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        return graphics;
    }

    public static Graphics2D setAlpha(Graphics2D graphics2D, float f2) {
        graphics2D.setComposite(AlphaComposite.getInstance(10, f2));
        return graphics2D;
    }
}

