/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date.format;

import com.ccb.core.date.DateException;
import com.ccb.core.date.format.AbstractDateBasic;
import com.ccb.core.date.format.DatePrinter;
import com.ccb.core.date.format.FastDatePrinter$CharacterLiteral;
import com.ccb.core.date.format.FastDatePrinter$DayInWeekField;
import com.ccb.core.date.format.FastDatePrinter$Iso8601_Rule;
import com.ccb.core.date.format.FastDatePrinter$NumberRule;
import com.ccb.core.date.format.FastDatePrinter$PaddedNumberField;
import com.ccb.core.date.format.FastDatePrinter$Rule;
import com.ccb.core.date.format.FastDatePrinter$StringLiteral;
import com.ccb.core.date.format.FastDatePrinter$TextField;
import com.ccb.core.date.format.FastDatePrinter$TimeZoneDisplayKey;
import com.ccb.core.date.format.FastDatePrinter$TimeZoneNameRule;
import com.ccb.core.date.format.FastDatePrinter$TimeZoneNumberRule;
import com.ccb.core.date.format.FastDatePrinter$TwelveHourField;
import com.ccb.core.date.format.FastDatePrinter$TwentyFourHourField;
import com.ccb.core.date.format.FastDatePrinter$TwoDigitMonthField;
import com.ccb.core.date.format.FastDatePrinter$TwoDigitNumberField;
import com.ccb.core.date.format.FastDatePrinter$TwoDigitYearField;
import com.ccb.core.date.format.FastDatePrinter$UnpaddedMonthField;
import com.ccb.core.date.format.FastDatePrinter$UnpaddedNumberField;
import com.ccb.core.date.format.FastDatePrinter$WeekYear;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FastDatePrinter
extends AbstractDateBasic
implements DatePrinter {
    private static final long serialVersionUID = -6305750172255764887L;
    private transient FastDatePrinter$Rule[] rules;
    private transient int mMaxLengthEstimate;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap C_TIME_ZONE_DISPLAY_CACHE = new ConcurrentHashMap(7);

    public FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        super(string, timeZone, locale);
        this.init();
    }

    private void init() {
        List list = this.parsePattern();
        this.rules = list.toArray(new FastDatePrinter$Rule[0]);
        int n2 = 0;
        int n3 = this.rules.length;
        while (--n3 >= 0) {
            n2 += this.rules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    protected List parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        ArrayList<FastDatePrinter$Iso8601_Rule> arrayList = new ArrayList<FastDatePrinter$Iso8601_Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n2 = this.pattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            FastDatePrinter$Rule fastDatePrinter$Rule;
            nArray[0] = i2;
            String string = this.parseToken(this.pattern, nArray);
            i2 = nArray[0];
            int n3 = string.length();
            if (n3 == 0) break;
            char c2 = string.charAt(0);
            switch (c2) {
                case 'G': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(0, stringArray);
                    break;
                }
                case 'Y': 
                case 'y': {
                    fastDatePrinter$Rule = n3 == 2 ? FastDatePrinter$TwoDigitYearField.INSTANCE : this.selectNumberRule(1, Math.max(n3, 4));
                    if (c2 != 'Y') break;
                    fastDatePrinter$Rule = new FastDatePrinter$WeekYear((FastDatePrinter$NumberRule)fastDatePrinter$Rule);
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        fastDatePrinter$Rule = new FastDatePrinter$TextField(2, stringArray2);
                        break;
                    }
                    if (n3 == 3) {
                        fastDatePrinter$Rule = new FastDatePrinter$TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 2) {
                        fastDatePrinter$Rule = FastDatePrinter$TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    fastDatePrinter$Rule = FastDatePrinter$UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    fastDatePrinter$Rule = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    fastDatePrinter$Rule = new FastDatePrinter$TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    fastDatePrinter$Rule = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    fastDatePrinter$Rule = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    fastDatePrinter$Rule = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    fastDatePrinter$Rule = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(7, n3 < 4 ? stringArray5 : stringArray4);
                    break;
                }
                case 'u': {
                    fastDatePrinter$Rule = new FastDatePrinter$DayInWeekField(this.selectNumberRule(7, n3));
                    break;
                }
                case 'D': {
                    fastDatePrinter$Rule = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    fastDatePrinter$Rule = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    fastDatePrinter$Rule = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    fastDatePrinter$Rule = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    fastDatePrinter$Rule = new FastDatePrinter$TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    fastDatePrinter$Rule = this.selectNumberRule(10, n3);
                    break;
                }
                case 'X': {
                    fastDatePrinter$Rule = FastDatePrinter$Iso8601_Rule.getRule(n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        fastDatePrinter$Rule = new FastDatePrinter$TimeZoneNameRule(this.timeZone, this.locale, 1);
                        break;
                    }
                    fastDatePrinter$Rule = new FastDatePrinter$TimeZoneNameRule(this.timeZone, this.locale, 0);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        fastDatePrinter$Rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n3 == 2) {
                        fastDatePrinter$Rule = FastDatePrinter$Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    fastDatePrinter$Rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        fastDatePrinter$Rule = new FastDatePrinter$CharacterLiteral(string2.charAt(0));
                        break;
                    }
                    fastDatePrinter$Rule = new FastDatePrinter$StringLiteral(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
            arrayList.add((FastDatePrinter$Iso8601_Rule)fastDatePrinter$Rule);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        char c2 = string.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    protected FastDatePrinter$NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new FastDatePrinter$UnpaddedNumberField(n2);
            }
            case 2: {
                return new FastDatePrinter$TwoDigitNumberField(n2);
            }
        }
        return new FastDatePrinter$PaddedNumberField(n2, n3);
    }

    String format(Object object) {
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    @Override
    public String format(long l2) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTimeInMillis(l2);
        return this.applyRulesToString(calendar);
    }

    @Override
    public String format(Date date) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTime(date);
        return this.applyRulesToString(calendar);
    }

    @Override
    public String format(Calendar calendar) {
        return ((StringBuilder)this.format(calendar, (Appendable)new StringBuilder(this.mMaxLengthEstimate))).toString();
    }

    @Override
    public Appendable format(long l2, Appendable appendable) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTimeInMillis(l2);
        return this.applyRules(calendar, appendable);
    }

    @Override
    public Appendable format(Date date, Appendable appendable) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTime(date);
        return this.applyRules(calendar, appendable);
    }

    @Override
    public Appendable format(Calendar calendar, Appendable appendable) {
        if (!calendar.getTimeZone().equals(this.timeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.timeZone);
        }
        return this.applyRules(calendar, appendable);
    }

    private String applyRulesToString(Calendar calendar) {
        return ((StringBuilder)this.applyRules(calendar, new StringBuilder(this.mMaxLengthEstimate))).toString();
    }

    private Appendable applyRules(Calendar calendar, Appendable appendable) {
        try {
            for (FastDatePrinter$Rule fastDatePrinter$Rule : this.rules) {
                fastDatePrinter$Rule.appendTo(appendable, calendar);
            }
        }
        catch (IOException iOException) {
            throw new DateException(iOException);
        }
        return appendable;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private static void appendDigits(Appendable appendable, int n2) {
        appendable.append((char)(n2 / 10 + 48));
        appendable.append((char)(n2 % 10 + 48));
    }

    private static void appendFullDigits(Appendable appendable, int n2, int n3) {
        if (n2 < 10000) {
            int n4 = 4;
            if (n2 < 1000) {
                --n4;
                if (n2 < 100) {
                    --n4;
                    if (n2 < 10) {
                        --n4;
                    }
                }
            }
            for (int i2 = n3 - n4; i2 > 0; --i2) {
                appendable.append('0');
            }
            switch (n4) {
                case 4: {
                    appendable.append((char)(n2 / 1000 + 48));
                    n2 %= 1000;
                }
                case 3: {
                    if (n2 >= 100) {
                        appendable.append((char)(n2 / 100 + 48));
                        n2 %= 100;
                    } else {
                        appendable.append('0');
                    }
                }
                case 2: {
                    if (n2 >= 10) {
                        appendable.append((char)(n2 / 10 + 48));
                        n2 %= 10;
                    } else {
                        appendable.append('0');
                    }
                }
                case 1: {
                    appendable.append((char)(n2 + 48));
                }
            }
        } else {
            char[] cArray = new char[10];
            int n5 = 0;
            while (n2 != 0) {
                cArray[n5++] = (char)(n2 % 10 + 48);
                n2 /= 10;
            }
            while (n5 < n3) {
                appendable.append('0');
                --n3;
            }
            while (--n5 >= 0) {
                appendable.append(cArray[n5]);
            }
        }
    }

    static String getTimeZoneDisplay(TimeZone timeZone, boolean bl, int n2, Locale locale) {
        String string;
        FastDatePrinter$TimeZoneDisplayKey fastDatePrinter$TimeZoneDisplayKey = new FastDatePrinter$TimeZoneDisplayKey(timeZone, bl, n2, locale);
        String string2 = (String)C_TIME_ZONE_DISPLAY_CACHE.get(fastDatePrinter$TimeZoneDisplayKey);
        if (string2 == null && (string = C_TIME_ZONE_DISPLAY_CACHE.putIfAbsent(fastDatePrinter$TimeZoneDisplayKey, string2 = timeZone.getDisplayName(bl, n2, locale))) != null) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ void access$000(Appendable appendable, int n2) {
        FastDatePrinter.appendDigits(appendable, n2);
    }

    static /* synthetic */ void access$100(Appendable appendable, int n2, int n3) {
        FastDatePrinter.appendFullDigits(appendable, n2, n3);
    }
}

