/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date.format;

import com.ccb.core.date.format.AbstractDateBasic;
import com.ccb.core.date.format.DateParser;
import com.ccb.core.date.format.FastDateParser$1;
import com.ccb.core.date.format.FastDateParser$2;
import com.ccb.core.date.format.FastDateParser$3;
import com.ccb.core.date.format.FastDateParser$4;
import com.ccb.core.date.format.FastDateParser$5;
import com.ccb.core.date.format.FastDateParser$CaseInsensitiveTextStrategy;
import com.ccb.core.date.format.FastDateParser$ISO8601TimeZoneStrategy;
import com.ccb.core.date.format.FastDateParser$NumberStrategy;
import com.ccb.core.date.format.FastDateParser$Strategy;
import com.ccb.core.date.format.FastDateParser$StrategyAndWidth;
import com.ccb.core.date.format.FastDateParser$StrategyParser;
import com.ccb.core.date.format.FastDateParser$TimeZoneStrategy;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FastDateParser
extends AbstractDateBasic
implements DateParser {
    private static final long serialVersionUID = -3199383897950947498L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final int century;
    private final int startYear;
    private transient List patterns;
    private static final Comparator LONGER_FIRST_LOWERCASE = Comparator.reverseOrder();
    private static final ConcurrentMap[] CACHES = new ConcurrentMap[17];
    private static final FastDateParser$Strategy ABBREVIATED_YEAR_STRATEGY = new FastDateParser$1(1);
    private static final FastDateParser$Strategy NUMBER_MONTH_STRATEGY = new FastDateParser$2(2);
    private static final FastDateParser$Strategy LITERAL_YEAR_STRATEGY = new FastDateParser$NumberStrategy(1);
    private static final FastDateParser$Strategy WEEK_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(3);
    private static final FastDateParser$Strategy WEEK_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(4);
    private static final FastDateParser$Strategy DAY_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(6);
    private static final FastDateParser$Strategy DAY_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(5);
    private static final FastDateParser$Strategy DAY_OF_WEEK_STRATEGY = new FastDateParser$3(7);
    private static final FastDateParser$Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new FastDateParser$NumberStrategy(8);
    private static final FastDateParser$Strategy HOUR_OF_DAY_STRATEGY = new FastDateParser$NumberStrategy(11);
    private static final FastDateParser$Strategy HOUR24_OF_DAY_STRATEGY = new FastDateParser$4(11);
    private static final FastDateParser$Strategy HOUR12_STRATEGY = new FastDateParser$5(10);
    private static final FastDateParser$Strategy HOUR_STRATEGY = new FastDateParser$NumberStrategy(10);
    private static final FastDateParser$Strategy MINUTE_STRATEGY = new FastDateParser$NumberStrategy(12);
    private static final FastDateParser$Strategy SECOND_STRATEGY = new FastDateParser$NumberStrategy(13);
    private static final FastDateParser$Strategy MILLISECOND_STRATEGY = new FastDateParser$NumberStrategy(14);

    public FastDateParser(String string, TimeZone timeZone, Locale locale) {
        this(string, timeZone, locale, null);
    }

    public FastDateParser(String string, TimeZone timeZone, Locale locale, Date date) {
        super(string, timeZone, locale);
        int n2;
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        if (date != null) {
            calendar.setTime(date);
            n2 = calendar.get(1);
        } else if (locale.equals(JAPANESE_IMPERIAL)) {
            n2 = 0;
        } else {
            calendar.setTime(new Date());
            n2 = calendar.get(1) - 80;
        }
        this.century = n2 / 100 * 100;
        this.startYear = n2 - this.century;
        this.init(calendar);
    }

    private void init(Calendar calendar) {
        FastDateParser$StrategyAndWidth fastDateParser$StrategyAndWidth;
        this.patterns = new ArrayList();
        FastDateParser$StrategyParser fastDateParser$StrategyParser = new FastDateParser$StrategyParser(this, calendar);
        while ((fastDateParser$StrategyAndWidth = fastDateParser$StrategyParser.getNextStrategy()) != null) {
            this.patterns.add(fastDateParser$StrategyAndWidth);
        }
    }

    private static boolean isFormatLetter(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        this.init(calendar);
    }

    @Override
    public Object parseObject(String string) {
        return this.parse(string);
    }

    @Override
    public Date parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (date == null) {
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\n" + "Unparseable date: \"" + string, parsePosition.getErrorIndex());
            }
            throw new ParseException("Unparseable date: " + string, parsePosition.getErrorIndex());
        }
        return date;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.clear();
        return this.parse(string, parsePosition, calendar) ? calendar.getTime() : null;
    }

    @Override
    public boolean parse(String string, ParsePosition parsePosition, Calendar calendar) {
        ListIterator listIterator = this.patterns.listIterator();
        while (listIterator.hasNext()) {
            FastDateParser$StrategyAndWidth fastDateParser$StrategyAndWidth = (FastDateParser$StrategyAndWidth)listIterator.next();
            int n2 = fastDateParser$StrategyAndWidth.getMaxWidth(listIterator);
            if (fastDateParser$StrategyAndWidth.strategy.parse(this, calendar, string, parsePosition, n2)) continue;
            return false;
        }
        return true;
    }

    private static StringBuilder simpleQuote(StringBuilder stringBuilder, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    private static Map appendDisplayNames(Calendar calendar, Locale locale, int n2, StringBuilder stringBuilder) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Map<String, Integer> map = calendar.getDisplayNames(n2, 0, locale);
        TreeSet<String> treeSet = new TreeSet<String>(LONGER_FIRST_LOWERCASE);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey().toLowerCase(locale);
            if (!treeSet.add(string)) continue;
            hashMap.put(string, entry.getValue());
        }
        for (String string : treeSet) {
            FastDateParser.simpleQuote(stringBuilder, string).append('|');
        }
        return hashMap;
    }

    private int adjustYear(int n2) {
        int n3 = this.century + n2;
        return n2 >= this.startYear ? n3 : n3 + 100;
    }

    private FastDateParser$Strategy getStrategy(char c2, int n2, Calendar calendar) {
        switch (c2) {
            default: {
                throw new IllegalArgumentException("Format '" + c2 + "' not supported");
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, calendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, calendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                return n2 >= 3 ? this.getLocaleSpecificStrategy(2, calendar) : NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, calendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'u': {
                return DAY_OF_WEEK_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'Y': 
            case 'y': {
                return n2 > 2 ? LITERAL_YEAR_STRATEGY : ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return FastDateParser$ISO8601TimeZoneStrategy.getStrategy(n2);
            }
            case 'Z': {
                if (n2 != 2) break;
                return FastDateParser$ISO8601TimeZoneStrategy.access$300();
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, calendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap getCache(int n2) {
        ConcurrentMap[] concurrentMapArray = CACHES;
        synchronized (CACHES) {
            if (CACHES[n2] == null) {
                FastDateParser.CACHES[n2] = new ConcurrentHashMap(3);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return CACHES[n2];
        }
    }

    private FastDateParser$Strategy getLocaleSpecificStrategy(int n2, Calendar calendar) {
        FastDateParser$Strategy fastDateParser$Strategy;
        ConcurrentMap concurrentMap = FastDateParser.getCache(n2);
        FastDateParser$Strategy fastDateParser$Strategy2 = (FastDateParser$Strategy)concurrentMap.get(this.locale);
        if (fastDateParser$Strategy2 == null && (fastDateParser$Strategy = concurrentMap.putIfAbsent(this.locale, fastDateParser$Strategy2 = n2 == 15 ? new FastDateParser$TimeZoneStrategy(this.locale) : new FastDateParser$CaseInsensitiveTextStrategy(n2, calendar, this.locale))) != null) {
            return fastDateParser$Strategy;
        }
        return fastDateParser$Strategy2;
    }

    static /* synthetic */ boolean access$000(char c2) {
        return FastDateParser.isFormatLetter(c2);
    }

    static /* synthetic */ FastDateParser$Strategy access$100(FastDateParser fastDateParser, char c2, int n2, Calendar calendar) {
        return fastDateParser.getStrategy(c2, n2, calendar);
    }

    static /* synthetic */ Map access$500(Calendar calendar, Locale locale, int n2, StringBuilder stringBuilder) {
        return FastDateParser.appendDisplayNames(calendar, locale, n2, stringBuilder);
    }

    static /* synthetic */ int access$600(FastDateParser fastDateParser, int n2) {
        return fastDateParser.adjustYear(n2);
    }

    static /* synthetic */ Comparator access$700() {
        return LONGER_FIRST_LOWERCASE;
    }

    static /* synthetic */ StringBuilder access$800(StringBuilder stringBuilder, String string) {
        return FastDateParser.simpleQuote(stringBuilder, string);
    }
}

