/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.date.DateUtil;
import com.ccb.core.date.StopWatch$TaskInfo;
import com.ccb.core.io.FileUtil;
import com.ccb.core.util.StrUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class StopWatch {
    private final String id;
    private List taskList;
    private String currentTaskName;
    private long startTimeNanos;
    private StopWatch$TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeNanos;

    public StopWatch() {
        this("");
    }

    public StopWatch(String string) {
        this(string, true);
    }

    public StopWatch(String string, boolean bl) {
        this.id = string;
        if (bl) {
            this.taskList = new ArrayList();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setKeepTaskList(boolean bl) {
        if (bl) {
            if (null == this.taskList) {
                this.taskList = new ArrayList();
            }
        } else {
            this.taskList = null;
        }
    }

    public void start() {
        this.start("");
    }

    public void start(String string) {
        if (null != this.currentTaskName) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.currentTaskName = string;
        this.startTimeNanos = System.nanoTime();
    }

    public void stop() {
        if (null == this.currentTaskName) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long l2 = System.nanoTime() - this.startTimeNanos;
        this.totalTimeNanos += l2;
        this.lastTaskInfo = new StopWatch$TaskInfo(this.currentTaskName, l2);
        if (null != this.taskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    public String currentTaskName() {
        return this.currentTaskName;
    }

    public long getLastTaskTimeNanos() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeNanos();
    }

    public long getLastTaskTimeMillis() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public String getLastTaskName() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task name");
        }
        return this.lastTaskInfo.getTaskName();
    }

    public StopWatch$TaskInfo getLastTaskInfo() {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task info");
        }
        return this.lastTaskInfo;
    }

    public long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public long getTotalTimeMillis() {
        return DateUtil.nanosToMillis(this.totalTimeNanos);
    }

    public double getTotalTimeSeconds() {
        return DateUtil.nanosToSeconds(this.totalTimeNanos);
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public StopWatch$TaskInfo[] getTaskInfo() {
        if (null == this.taskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new StopWatch$TaskInfo[0]);
    }

    public String shortSummary() {
        return StrUtil.format((CharSequence)"StopWatch '{}': running time = {} ns", this.id, this.totalTimeNanos);
    }

    public String prettyPrint() {
        StringBuilder stringBuilder = new StringBuilder(this.shortSummary());
        stringBuilder.append(FileUtil.getLineSeparator());
        if (null == this.taskList) {
            stringBuilder.append("No task info kept");
        } else {
            stringBuilder.append("---------------------------------------------").append(FileUtil.getLineSeparator());
            stringBuilder.append("ns         %     Task name").append(FileUtil.getLineSeparator());
            stringBuilder.append("---------------------------------------------").append(FileUtil.getLineSeparator());
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumIntegerDigits(9);
            numberFormat.setGroupingUsed(false);
            NumberFormat numberFormat2 = NumberFormat.getPercentInstance();
            numberFormat2.setMinimumIntegerDigits(3);
            numberFormat2.setGroupingUsed(false);
            for (StopWatch$TaskInfo stopWatch$TaskInfo : this.getTaskInfo()) {
                stringBuilder.append(numberFormat.format(stopWatch$TaskInfo.getTimeNanos())).append("  ");
                stringBuilder.append(numberFormat2.format((double)stopWatch$TaskInfo.getTimeNanos() / (double)this.getTotalTimeNanos())).append("  ");
                stringBuilder.append(stopWatch$TaskInfo.getTaskName()).append(FileUtil.getLineSeparator());
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.shortSummary());
        if (null != this.taskList) {
            for (StopWatch$TaskInfo stopWatch$TaskInfo : this.taskList) {
                stringBuilder.append("; [").append(stopWatch$TaskInfo.getTaskName()).append("] took ").append(stopWatch$TaskInfo.getTimeNanos()).append(" ns");
                long l2 = Math.round(100.0 * (double)stopWatch$TaskInfo.getTimeNanos() / (double)this.getTotalTimeNanos());
                stringBuilder.append(" = ").append(l2).append("%");
            }
        } else {
            stringBuilder.append("; no task info kept");
        }
        return stringBuilder.toString();
    }
}

