/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.comparator.CompareUtil;
import com.ccb.core.date.BetweenFormater;
import com.ccb.core.date.BetweenFormater$Level;
import com.ccb.core.date.CalendarUtil;
import com.ccb.core.date.DateBetween;
import com.ccb.core.date.DateException;
import com.ccb.core.date.DateField;
import com.ccb.core.date.DatePattern;
import com.ccb.core.date.DateRange;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.DateUnit;
import com.ccb.core.date.LocalDateTimeUtil;
import com.ccb.core.date.Month;
import com.ccb.core.date.Quarter;
import com.ccb.core.date.StopWatch;
import com.ccb.core.date.TemporalAccessorUtil;
import com.ccb.core.date.TimeInterval;
import com.ccb.core.date.Week;
import com.ccb.core.date.Zodiac;
import com.ccb.core.date.format.DateParser;
import com.ccb.core.date.format.DatePrinter;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.PatternPool;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.ReUtil;
import com.ccb.core.util.StrUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;

public class DateUtil
extends CalendarUtil {
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime dateSecond() {
        return DateUtil.beginOfSecond(DateUtil.date());
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtil.dateNew(date);
    }

    public static DateTime dateNew(Date date) {
        return new DateTime(date);
    }

    public static DateTime date(long l2) {
        return new DateTime(l2);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        return new DateTime(temporalAccessor);
    }

    public static long current(boolean bl) {
        return bl ? System.nanoTime() : System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfYear(Date date) {
        return DateTime.of(date).dayOfYear();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Week dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int hour(Date date, boolean bl) {
        return DateTime.of(date).hour(bl);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millsecond(Date date) {
        return DateTime.of(date).millisecond();
    }

    public static int millisecond(Date date) {
        return DateTime.of(date).millisecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.date());
    }

    public static Month thisMonthEnum() {
        return DateUtil.monthEnum(DateUtil.date());
    }

    public static int thisWeekOfYear() {
        return DateUtil.weekOfYear(DateUtil.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtil.weekOfMonth(DateUtil.date());
    }

    public static int thisDayOfMonth() {
        return DateUtil.dayOfMonth(DateUtil.date());
    }

    public static int thisDayOfWeek() {
        return DateUtil.dayOfWeek(DateUtil.date());
    }

    public static Week thisDayOfWeekEnum() {
        return DateUtil.dayOfWeekEnum(DateUtil.date());
    }

    public static int thisHour(boolean bl) {
        return DateUtil.hour(DateUtil.date(), bl);
    }

    public static int thisMinute() {
        return DateUtil.minute(DateUtil.date());
    }

    public static int thisSecond() {
        return DateUtil.second(DateUtil.date());
    }

    public static int thisMillsecond() {
        return DateUtil.millisecond(DateUtil.date());
    }

    public static int thisMillisecond() {
        return DateUtil.millisecond(DateUtil.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtil.yearAndQuarter(DateUtil.calendar(date));
    }

    public static LinkedHashSet yearAndQuarter(Date date, Date date2) {
        if (date == null || date2 == null) {
            return new LinkedHashSet(0);
        }
        return DateUtil.yearAndQuarter(date.getTime(), date2.getTime());
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.formatNormal(localDateTime);
    }

    public static String format(LocalDateTime localDateTime, String string) {
        return LocalDateTimeUtil.format(localDateTime, string);
    }

    public static String format(Date date, String string) {
        TimeZone timeZone;
        if (null == date || StrUtil.isBlank(string)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        if (date instanceof DateTime && null != (timeZone = ((DateTime)date).getTimeZone())) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return DateUtil.format(date, simpleDateFormat);
    }

    public static String format(Date date, DatePrinter datePrinter) {
        if (null == datePrinter || null == date) {
            return null;
        }
        return datePrinter.format(date);
    }

    public static String format(Date date, DateFormat dateFormat) {
        if (null == dateFormat || null == date) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static String format(Date date, DateTimeFormatter dateTimeFormatter) {
        if (null == dateTimeFormatter || null == date) {
            return null;
        }
        return dateTimeFormatter.format(date.toInstant());
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_TIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatChineseDate(Date date, boolean bl, boolean bl2) {
        if (null == date) {
            return null;
        }
        if (!bl) {
            return (bl2 ? DatePattern.CHINESE_DATE_TIME_FORMAT : DatePattern.CHINESE_DATE_FORMAT).format(date);
        }
        return CalendarUtil.formatChineseDate(CalendarUtil.calendar(date), bl2);
    }

    public static LocalDateTime parseLocalDateTime(CharSequence charSequence) {
        return DateUtil.parseLocalDateTime(charSequence, "yyyy-MM-dd HH:mm:ss");
    }

    public static LocalDateTime parseLocalDateTime(CharSequence charSequence, String string) {
        return LocalDateTimeUtil.parse(charSequence, string);
    }

    public static DateTime parse(CharSequence charSequence, DateFormat dateFormat) {
        return new DateTime(charSequence, dateFormat);
    }

    public static DateTime parse(CharSequence charSequence, DateParser dateParser) {
        return new DateTime(charSequence, dateParser);
    }

    public static DateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return new DateTime(charSequence, dateTimeFormatter);
    }

    public static DateTime parse(CharSequence charSequence, String string) {
        return new DateTime(charSequence, string);
    }

    public static DateTime parse(CharSequence charSequence, String string, Locale locale) {
        return new DateTime(charSequence, new SimpleDateFormat(string, locale));
    }

    public static DateTime parse(String string, String ... stringArray) {
        return new DateTime(CalendarUtil.parseByPatterns(string, stringArray));
    }

    public static DateTime parseDateTime(CharSequence charSequence) {
        charSequence = DateUtil.normalize(charSequence);
        return DateUtil.parse(charSequence, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseDate(CharSequence charSequence) {
        charSequence = DateUtil.normalize(charSequence);
        return DateUtil.parse(charSequence, DatePattern.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(CharSequence charSequence) {
        charSequence = DateUtil.normalize(charSequence);
        return DateUtil.parse(charSequence, DatePattern.NORM_TIME_FORMAT);
    }

    public static DateTime parseTimeToday(CharSequence charSequence) {
        charSequence = StrUtil.format((CharSequence)"{} {}", DateUtil.today(), charSequence);
        if (1 == StrUtil.count(charSequence, ':')) {
            return DateUtil.parse(charSequence, "yyyy-MM-dd HH:mm");
        }
        return DateUtil.parse(charSequence, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (StrUtil.contains((CharSequence)string, 'Z')) {
            if (n2 == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_FORMAT);
            }
            if (n2 == "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length() - 4) {
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (n2 == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 2 || n2 == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 3) {
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_WITH_ZONE_OFFSET_FORMAT);
            }
            if (n2 == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 2 || n2 == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 3) {
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_MS_WITH_ZONE_OFFSET_FORMAT);
            }
            if (n2 == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return DateUtil.parse((CharSequence)string, DatePattern.UTC_SIMPLE_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", string);
    }

    public static DateTime parseCST(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return DateUtil.parse(charSequence, DatePattern.JDK_DATETIME_FORMAT);
    }

    public static DateTime parse(CharSequence charSequence) {
        if (StrUtil.isBlank(charSequence)) {
            return null;
        }
        String string = charSequence.toString();
        string = StrUtil.removeAll((CharSequence)string.trim(), '\u65e5', '\u79d2');
        int n2 = string.length();
        if (NumberUtil.isNumber(string)) {
            if (n2 == "yyyyMMddHHmmss".length()) {
                return DateUtil.parse((CharSequence)string, DatePattern.PURE_DATETIME_FORMAT);
            }
            if (n2 == "yyyyMMddHHmmssSSS".length()) {
                return DateUtil.parse((CharSequence)string, DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (n2 == "yyyyMMdd".length()) {
                return DateUtil.parse((CharSequence)string, DatePattern.PURE_DATE_FORMAT);
            }
            if (n2 == "HHmmss".length()) {
                return DateUtil.parse((CharSequence)string, DatePattern.PURE_TIME_FORMAT);
            }
        } else {
            if (ReUtil.isMatch(PatternPool.TIME, (CharSequence)string)) {
                return DateUtil.parseTimeToday(string);
            }
            if (StrUtil.containsAnyIgnoreCase(string, wtb)) {
                return DateUtil.parseCST(string);
            }
            if (StrUtil.contains((CharSequence)string, 'T')) {
                return DateUtil.parseUTC(string);
            }
        }
        string = DateUtil.normalize(string);
        Matcher matcher = DatePattern.REGEX_NORM.matcher(string);
        if (ReUtil.isMatch(DatePattern.REGEX_NORM, (CharSequence)string)) {
            int n3 = StrUtil.count((CharSequence)string, ':');
            switch (n3) {
                case 0: {
                    return DateUtil.parse((CharSequence)string, DatePattern.NORM_DATE_FORMAT);
                }
                case 1: {
                    return DateUtil.parse((CharSequence)string, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    if (StrUtil.contains((CharSequence)string, '.')) {
                        return DateUtil.parse((CharSequence)string, DatePattern.NORM_DATETIME_MS_FORMAT);
                    }
                    return DateUtil.parse((CharSequence)string, DatePattern.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new DateException("No format fit for date String [{}] !", string);
    }

    public static DateTime truncate(Date date, DateField dateField) {
        return new DateTime(DateUtil.truncate(DateUtil.calendar(date), dateField));
    }

    public static DateTime round(Date date, DateField dateField) {
        return new DateTime(DateUtil.round(DateUtil.calendar(date), dateField));
    }

    public static DateTime ceiling(Date date, DateField dateField) {
        return new DateTime(DateUtil.ceiling(DateUtil.calendar(date), dateField));
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(DateUtil.beginOfSecond(DateUtil.calendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(DateUtil.endOfSecond(DateUtil.calendar(date)));
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime beginOfWeek(Date date, boolean bl) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date), bl));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime endOfWeek(Date date, boolean bl) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date), bl));
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateUtil.beginOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateUtil.endOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateUtil.beginOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateUtil.endOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateUtil.beginOfYear(DateUtil.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateUtil.endOfYear(DateUtil.calendar(date)));
    }

    public static DateTime yesterday() {
        return DateUtil.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtil.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtil.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtil.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtil.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int n2) {
        return DateUtil.offset(date, DateField.MILLISECOND, n2);
    }

    public static DateTime offsetSecond(Date date, int n2) {
        return DateUtil.offset(date, DateField.SECOND, n2);
    }

    public static DateTime offsetMinute(Date date, int n2) {
        return DateUtil.offset(date, DateField.MINUTE, n2);
    }

    public static DateTime offsetHour(Date date, int n2) {
        return DateUtil.offset(date, DateField.HOUR_OF_DAY, n2);
    }

    public static DateTime offsetDay(Date date, int n2) {
        return DateUtil.offset(date, DateField.DAY_OF_YEAR, n2);
    }

    public static DateTime offsetWeek(Date date, int n2) {
        return DateUtil.offset(date, DateField.WEEK_OF_YEAR, n2);
    }

    public static DateTime offsetMonth(Date date, int n2) {
        return DateUtil.offset(date, DateField.MONTH, n2);
    }

    public static DateTime offset(Date date, DateField dateField, int n2) {
        return DateUtil.dateNew(date).offset(dateField, n2);
    }

    public static DateTime offsetDate(Date date, DateField dateField, int n2) {
        return DateUtil.offset(date, dateField, n2);
    }

    public static long between(Date date, Date date2, DateUnit dateUnit) {
        return DateUtil.between(date, date2, dateUnit, true);
    }

    public static long between(Date date, Date date2, DateUnit dateUnit, boolean bl) {
        return new DateBetween(date, date2, bl).between(dateUnit);
    }

    public static long betweenMs(Date date, Date date2) {
        return new DateBetween(date, date2).between(DateUnit.MS);
    }

    public static long betweenDay(Date date, Date date2, boolean bl) {
        if (bl) {
            date = DateUtil.beginOfDay(date);
            date2 = DateUtil.beginOfDay(date2);
        }
        return DateUtil.between(date, date2, DateUnit.DAY);
    }

    public static long betweenWeek(Date date, Date date2, boolean bl) {
        if (bl) {
            date = DateUtil.beginOfDay(date);
            date2 = DateUtil.beginOfDay(date2);
        }
        return DateUtil.between(date, date2, DateUnit.WEEK);
    }

    public static long betweenMonth(Date date, Date date2, boolean bl) {
        return new DateBetween(date, date2).betweenMonth(bl);
    }

    public static long betweenYear(Date date, Date date2, boolean bl) {
        return new DateBetween(date, date2).betweenYear(bl);
    }

    public static String formatBetween(Date date, Date date2, BetweenFormater$Level betweenFormater$Level) {
        return DateUtil.formatBetween(DateUtil.between(date, date2, DateUnit.MS), betweenFormater$Level);
    }

    public static String formatBetween(Date date, Date date2) {
        return DateUtil.formatBetween(DateUtil.between(date, date2, DateUnit.MS));
    }

    public static String formatBetween(long l2, BetweenFormater$Level betweenFormater$Level) {
        return new BetweenFormater(l2, betweenFormater$Level).format();
    }

    public static String formatBetween(long l2) {
        return new BetweenFormater(l2, BetweenFormater$Level.MILLISECOND).format();
    }

    public static boolean isIn(Date date, Date date2, Date date3) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(date2, date3);
        }
        return new DateTime(date).isIn(date2, date3);
    }

    public static boolean isSameTime(Date date, Date date2) {
        return date.compareTo(date2) == 0;
    }

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameDay(DateUtil.calendar(date), DateUtil.calendar(date2));
    }

    public static boolean isSameMonth(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return CalendarUtil.isSameMonth(DateUtil.calendar(date), DateUtil.calendar(date2));
    }

    public static long spendNt(long l2) {
        return System.nanoTime() - l2;
    }

    public static long spendMs(long l2) {
        return System.currentTimeMillis() - l2;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date date, Date date2) {
        return (int)DateUtil.betweenWeek(date, date2, true);
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static TimeInterval timer(boolean bl) {
        return new TimeInterval(bl);
    }

    public static StopWatch createStopWatch() {
        return new StopWatch();
    }

    public static StopWatch createStopWatch(String string) {
        return new StopWatch(string);
    }

    public static int ageOfNow(String string) {
        return DateUtil.ageOfNow(DateUtil.parse(string));
    }

    public static int ageOfNow(Date date) {
        return DateUtil.age(date, DateUtil.date());
    }

    public static boolean isLeapYear(int n2) {
        return new GregorianCalendar().isLeapYear(n2);
    }

    public static int age(Date date, Date date2) {
        Assert.notNull(date, "Birthday can not be null !", new Object[0]);
        if (null == date2) {
            date2 = DateUtil.date();
        }
        return DateUtil.age(date.getTime(), date2.getTime());
    }

    public static boolean isExpired(Date date, DateField dateField, int n2, Date date2) {
        DateTime dateTime = DateUtil.offset(date, dateField, n2);
        return dateTime.after(date2);
    }

    public static boolean isExpired(Date date, Date date2, Date date3) {
        return DateUtil.betweenMs(date, date3) > DateUtil.betweenMs(date, date2);
    }

    public static int timeToSecond(String string) {
        if (StrUtil.isEmpty(string)) {
            return 0;
        }
        List list = StrUtil.splitTrim((CharSequence)string, ':', 3);
        int n2 = list.size() - 1;
        int n3 = 0;
        for (int i2 = n2; i2 >= 0; --i2) {
            n3 = (int)((double)n3 + (double)Integer.parseInt((String)list.get(i2)) * Math.pow(60.0, n2 - i2));
        }
        return n3;
    }

    public static String secondToTime(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int n3 = n2 / 3600;
        int n4 = n2 % 3600;
        int n5 = n4 / 60;
        int n6 = n4 % 60;
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n3);
        stringBuilder.append(":");
        if (n5 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n5);
        stringBuilder.append(":");
        if (n6 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n6);
        return stringBuilder.toString();
    }

    public static DateRange range(Date date, Date date2, DateField dateField) {
        return new DateRange(date, date2, dateField);
    }

    public static List rangeToList(Date date, Date date2, DateField dateField) {
        return CollUtil.newArrayList(DateUtil.range(date, date2, dateField));
    }

    public static String getZodiac(int n2, int n3) {
        return Zodiac.getZodiac(n2, n3);
    }

    public static String getChineseZodiac(int n2) {
        return Zodiac.getChineseZodiac(n2);
    }

    public static int compare(Date date, Date date2) {
        return CompareUtil.compare(date, date2);
    }

    public static long nanosToMillis(long l2) {
        return TimeUnit.NANOSECONDS.toMillis(l2);
    }

    public static double nanosToSeconds(long l2) {
        return (double)l2 / 1.0E9;
    }

    public static Instant toInstant(Date date) {
        return null == date ? null : date.toInstant();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTimeUtil.of(instant);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTimeUtil.of(date);
    }

    public static int lengthOfYear(int n2) {
        return Year.of(n2).length();
    }

    public static int lengthOfMonth(int n2, boolean bl) {
        return java.time.Month.of(n2).length(bl);
    }

    private static String normalize(CharSequence charSequence) {
        if (StrUtil.isBlank(charSequence)) {
            return StrUtil.str(charSequence);
        }
        List list = StrUtil.splitTrim(charSequence, ' ');
        int n2 = list.size();
        if (n2 < 1 || n2 > 2) {
            return StrUtil.str(charSequence);
        }
        StringBuilder stringBuilder = StrUtil.builder();
        String string = ((String)list.get(0)).replaceAll("[/.\u5e74\u6708]", "-");
        string = StrUtil.removeSuffix(string, "\u65e5");
        stringBuilder.append(string);
        if (n2 == 2) {
            stringBuilder.append(' ');
            String string2 = ((String)list.get(1)).replaceAll("[\u65f6\u5206\u79d2]", ":");
            string2 = StrUtil.removeSuffix(string2, ":");
            string2 = string2.replace(',', '.');
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

