/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.date.BetweenFormater$Level;
import com.ccb.core.date.DateBetween;
import com.ccb.core.date.DateException;
import com.ccb.core.date.DateField;
import com.ccb.core.date.DatePattern;
import com.ccb.core.date.DateUnit;
import com.ccb.core.date.DateUtil;
import com.ccb.core.date.Month;
import com.ccb.core.date.Quarter;
import com.ccb.core.date.Week;
import com.ccb.core.date.format.DateParser;
import com.ccb.core.date.format.DatePrinter;
import com.ccb.core.date.format.FastDateFormat;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime
extends java.util.Date {
    private static final long serialVersionUID = -5395712593979185936L;
    private boolean mutable = true;
    private Week firstDayOfWeek = Week.MONDAY;
    private TimeZone timeZone;

    public static DateTime of(long l2) {
        return new DateTime(l2);
    }

    public static DateTime of(java.util.Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String string, String string2) {
        return new DateTime((CharSequence)string, string2);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public DateTime() {
        this(TimeZone.getDefault());
    }

    public DateTime(TimeZone timeZone) {
        this(System.currentTimeMillis(), timeZone);
    }

    public DateTime(java.util.Date date) {
        this(date.getTime(), date instanceof DateTime ? ((DateTime)date).timeZone : TimeZone.getDefault());
    }

    public DateTime(java.util.Date date, TimeZone timeZone) {
        this(date.getTime(), timeZone);
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime(), calendar.getTimeZone());
        this.setFirstDayOfWeek(Week.of(calendar.getFirstDayOfWeek()));
    }

    public DateTime(Instant instant) {
        this(instant.toEpochMilli());
    }

    public DateTime(Instant instant, ZoneId zoneId) {
        this(instant.toEpochMilli(), TimeZone.getTimeZone((ZoneId)ObjectUtil.defaultIfNull(zoneId, ZoneId.systemDefault())));
    }

    public DateTime(TemporalAccessor temporalAccessor) {
        this(DateUtil.toInstant(temporalAccessor));
    }

    public DateTime(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public DateTime(long l2) {
        this(l2, TimeZone.getDefault());
    }

    public DateTime(long l2, TimeZone timeZone) {
        super(l2);
        this.timeZone = (TimeZone)ObjectUtil.defaultIfNull(timeZone, TimeZone.getDefault());
    }

    public DateTime(CharSequence charSequence, String string) {
        this(charSequence, new SimpleDateFormat(string));
    }

    public DateTime(CharSequence charSequence, DateFormat dateFormat) {
        this(DateTime.parse(charSequence, dateFormat), dateFormat.getTimeZone());
    }

    public DateTime(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        this(Instant.from(dateTimeFormatter.parse(charSequence)), dateTimeFormatter.getZone());
    }

    public DateTime(CharSequence charSequence, DateParser dateParser) {
        this(DateTime.parse(charSequence, dateParser), dateParser.getTimeZone());
    }

    public DateTime offset(DateField dateField, int n2) {
        if (DateField.ERA == dateField) {
            throw new IllegalArgumentException("ERA is not support offset!");
        }
        Calendar calendar = this.toCalendar();
        calendar.add(dateField.getValue(), n2);
        DateTime dateTime = this.mutable ? this : (DateTime)ObjectUtil.clone(this);
        return dateTime.setTimeInternal(calendar.getTimeInMillis());
    }

    public DateTime offsetNew(DateField dateField, int n2) {
        Calendar calendar = this.toCalendar();
        calendar.add(dateField.getValue(), n2);
        DateTime dateTime = (DateTime)ObjectUtil.clone(this);
        return dateTime.setTimeInternal(calendar.getTimeInMillis());
    }

    public int getField(DateField dateField) {
        return this.getField(dateField.getValue());
    }

    public int getField(int n2) {
        return this.toCalendar().get(n2);
    }

    public DateTime setField(DateField dateField, int n2) {
        return this.setField(dateField.getValue(), n2);
    }

    public DateTime setField(int n2, int n3) {
        Calendar calendar = this.toCalendar();
        calendar.set(n2, n3);
        DateTime dateTime = this;
        if (!this.mutable) {
            dateTime = (DateTime)ObjectUtil.clone(this);
        }
        return dateTime.setTimeInternal(calendar.getTimeInMillis());
    }

    @Override
    public void setTime(long l2) {
        if (!this.mutable) {
            throw new DateException("This is not a mutable object !");
        }
        super.setTime(l2);
    }

    public int year() {
        return this.getField(DateField.YEAR);
    }

    public int quarter() {
        return this.month() / 3 + 1;
    }

    public Quarter quarterEnum() {
        return Quarter.of(this.quarter());
    }

    public int month() {
        return this.getField(DateField.MONTH);
    }

    public int monthBaseOne() {
        return this.month() + 1;
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public Month monthEnum() {
        return Month.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(DateField.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(DateField.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(DateField.DAY_OF_MONTH);
    }

    public int dayOfYear() {
        return this.getField(DateField.DAY_OF_YEAR);
    }

    public int dayOfWeek() {
        return this.getField(DateField.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(DateField.DAY_OF_WEEK_IN_MONTH);
    }

    public Week dayOfWeekEnum() {
        return Week.of(this.dayOfWeek());
    }

    public int hour(boolean bl) {
        return this.getField(bl ? DateField.HOUR_OF_DAY : DateField.HOUR);
    }

    public int minute() {
        return this.getField(DateField.MINUTE);
    }

    public int second() {
        return this.getField(DateField.SECOND);
    }

    public int millisecond() {
        return this.getField(DateField.MILLISECOND);
    }

    public int millsecond() {
        return this.getField(DateField.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(DateField.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(DateField.AM_PM);
    }

    public boolean isWeekend() {
        int n2 = this.dayOfWeek();
        return 7 == n2 || 1 == n2;
    }

    public boolean isLeapYear() {
        return DateUtil.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        return this.toCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(Locale locale) {
        return this.toCalendar(this.timeZone, locale);
    }

    public Calendar toCalendar(TimeZone timeZone) {
        return this.toCalendar(timeZone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(TimeZone timeZone, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        Calendar calendar = null != timeZone ? Calendar.getInstance(timeZone, locale) : Calendar.getInstance(locale);
        calendar.setFirstDayOfWeek(this.firstDayOfWeek.getValue());
        calendar.setTime(this);
        return calendar;
    }

    public java.util.Date toJdkDate() {
        return new java.util.Date(this.getTime());
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Date toSqlDate() {
        return new Date(this.getTime());
    }

    public DateBetween between(java.util.Date date) {
        return new DateBetween(this, date);
    }

    public long between(java.util.Date date, DateUnit dateUnit) {
        return new DateBetween(this, date).between(dateUnit);
    }

    public String between(java.util.Date date, DateUnit dateUnit, BetweenFormater$Level betweenFormater$Level) {
        return new DateBetween(this, date).toString(betweenFormater$Level);
    }

    public boolean isIn(java.util.Date date, java.util.Date date2) {
        long l2 = date.getTime();
        long l3 = date2.getTime();
        long l4 = this.getTime();
        return l4 >= Math.min(l2, l3) && l4 <= Math.max(l2, l3);
    }

    public boolean isBefore(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) < 0;
    }

    public boolean isBeforeOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) <= 0;
    }

    public boolean isAfter(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) > 0;
    }

    public boolean isAfterOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) >= 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean bl) {
        this.mutable = bl;
        return this;
    }

    public Week getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public DateTime setFirstDayOfWeek(Week week) {
        this.firstDayOfWeek = week;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ZoneId getZoneId() {
        return this.timeZone.toZoneId();
    }

    public DateTime setTimeZone(TimeZone timeZone) {
        this.timeZone = (TimeZone)ObjectUtil.defaultIfNull(timeZone, TimeZone.getDefault());
        return this;
    }

    @Override
    public String toString() {
        return this.toString(this.timeZone);
    }

    public String toStringDefaultTimeZone() {
        return this.toString(TimeZone.getDefault());
    }

    public String toString(TimeZone timeZone) {
        if (null != timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setTimeZone(timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(DatePattern.NORM_DATETIME_FORMAT);
    }

    public String toDateStr() {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(DatePattern.NORM_DATE_FORMAT);
    }

    public String toTimeStr() {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(DatePattern.NORM_TIME_FORMAT);
    }

    public String toString(String string) {
        if (null != this.timeZone) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            simpleDateFormat.setTimeZone(this.timeZone);
            return this.toString(simpleDateFormat);
        }
        return this.toString(FastDateFormat.getInstance(string));
    }

    public String toString(DatePrinter datePrinter) {
        return datePrinter.format(this);
    }

    public String toString(DateFormat dateFormat) {
        return dateFormat.format(this);
    }

    public String toMsStr() {
        return this.toString(DatePattern.NORM_DATETIME_MS_FORMAT);
    }

    private static java.util.Date parse(CharSequence charSequence, DateFormat dateFormat) {
        Assert.notBlank(charSequence, "Date String must be not blank !", new Object[0]);
        try {
            return dateFormat.parse(charSequence.toString());
        }
        catch (Exception exception) {
            String string = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new DateException(StrUtil.format((CharSequence)"Parse [{}] with format [{}] error!", charSequence, string), exception);
        }
    }

    private static java.util.Date parse(CharSequence charSequence, DateParser dateParser) {
        Assert.notNull(dateParser, "Parser or DateFromat must be not null !", new Object[0]);
        Assert.notBlank(charSequence, "Date String must be not blank !", new Object[0]);
        try {
            return dateParser.parse(charSequence.toString());
        }
        catch (Exception exception) {
            throw new DateException("Parse [{}] with format [{}] error!", charSequence, dateParser.getPattern(), exception);
        }
    }

    private DateTime setTimeInternal(long l2) {
        super.setTime(l2);
        return this;
    }
}

