/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert;

import com.ccb.core.util.StrUtil;

public class NumberWordFormatter {
    private static final String[] NUMBER = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
    private static final String[] NUMBER_TEEN = new String[]{"TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    private static final String[] NUMBER_TEN = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    private static final String[] NUMBER_MORE = new String[]{"", "THOUSAND", "MILLION", "BILLION"};

    public static String format(Object object) {
        if (object != null) {
            return NumberWordFormatter.format(object.toString());
        }
        return "";
    }

    private static String format(String string) {
        String string2;
        int n2 = string.indexOf(".");
        String string3 = "";
        if (n2 > -1) {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        } else {
            string2 = string;
        }
        String string4 = StrUtil.reverse(string2);
        String[] stringArray = new String[5];
        switch (string4.length() % 3) {
            case 1: {
                string4 = string4 + "00";
                break;
            }
            case 2: {
                string4 = string4 + "0";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string4.length() / 3; ++i2) {
            stringArray[i2] = StrUtil.reverse(string4.substring(3 * i2, 3 * i2 + 3));
            if (!"000".equals(stringArray[i2])) {
                if (i2 != 0) {
                    stringBuilder.insert(0, NumberWordFormatter.transThree(stringArray[i2]) + " " + NumberWordFormatter.parseMore(i2) + " ");
                    continue;
                }
                stringBuilder = new StringBuilder(NumberWordFormatter.transThree(stringArray[i2]));
                continue;
            }
            stringBuilder.append(NumberWordFormatter.transThree(stringArray[i2]));
        }
        String string5 = "";
        if (n2 > -1) {
            string5 = "AND CENTS " + NumberWordFormatter.transTwo(string3) + " ";
        }
        return stringBuilder.toString().trim() + " " + string5 + "ONLY";
    }

    private static String parseFirst(String string) {
        return NUMBER[Integer.parseInt(string.substring(string.length() - 1))];
    }

    private static String parseTeen(String string) {
        return NUMBER_TEEN[Integer.parseInt(string) - 10];
    }

    private static String parseTen(String string) {
        return NUMBER_TEN[Integer.parseInt(string.substring(0, 1)) - 1];
    }

    private static String parseMore(int n2) {
        return NUMBER_MORE[n2];
    }

    private static String transTwo(String string) {
        if (string.length() > 2) {
            string = string.substring(0, 2);
        } else if (string.length() < 2) {
            string = "0" + string;
        }
        String string2 = string.startsWith("0") ? NumberWordFormatter.parseFirst(string) : (string.startsWith("1") ? NumberWordFormatter.parseTeen(string) : (string.endsWith("0") ? NumberWordFormatter.parseTen(string) : NumberWordFormatter.parseTen(string) + " " + NumberWordFormatter.parseFirst(string)));
        return string2;
    }

    private static String transThree(String string) {
        String string2 = string.startsWith("0") ? NumberWordFormatter.transTwo(string.substring(1)) : ("00".equals(string.substring(1)) ? NumberWordFormatter.parseFirst(string.substring(0, 1)) + " HUNDRED" : NumberWordFormatter.parseFirst(string.substring(0, 1)) + " HUNDRED AND " + NumberWordFormatter.transTwo(string.substring(1)));
        return string2;
    }
}

