/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.collection;

import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.lang.Assert;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIter
implements Closeable,
Serializable,
Iterable,
Iterator {
    private static final long serialVersionUID = 1L;
    private final BufferedReader bufferedReader;
    private String cachedLine;
    private boolean finished = false;

    public LineIter(InputStream inputStream, Charset charset) {
        this(IoUtil.getReader(inputStream, charset));
    }

    public LineIter(Reader reader) {
        Assert.notNull(reader, "Reader must not be null", new Object[0]);
        this.bufferedReader = IoUtil.getReader(reader);
    }

    @Override
    public boolean hasNext() {
        if (this.cachedLine != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        try {
            String string;
            do {
                if ((string = this.bufferedReader.readLine()) != null) continue;
                this.finished = true;
                return false;
            } while (!this.isValidLine(string));
            this.cachedLine = string;
            return true;
        }
        catch (IOException iOException) {
            this.close();
            throw new IORuntimeException(iOException);
        }
    }

    public String next() {
        return this.nextLine();
    }

    public String nextLine() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines");
        }
        String string = this.cachedLine;
        this.cachedLine = null;
        return string;
    }

    @Override
    public void close() {
        this.finished = true;
        IoUtil.close(this.bufferedReader);
        this.cachedLine = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported on LineIterator");
    }

    protected boolean isValidLine(String string) {
        return true;
    }

    public Iterator iterator() {
        return this;
    }
}

