/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.codec;

import com.ccb.core.util.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;

public class Base62Codec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int STANDARD_BASE = 256;
    private static final int TARGET_BASE = 62;
    private static final byte[] GMP = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] INVERTED = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private final byte[] alphabet;
    private final byte[] lookup;

    public static Base62Codec createGmp() {
        return new Base62Codec(GMP);
    }

    public static Base62Codec createInverted() {
        return new Base62Codec(INVERTED);
    }

    public Base62Codec(byte[] byArray) {
        this.alphabet = byArray;
        this.lookup = new byte[256];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.lookup[byArray[i2]] = (byte)(i2 & 0xFF);
        }
    }

    public byte[] encode(byte[] byArray) {
        byte[] byArray2 = this.convert(byArray, 256, 62);
        return this.translate(byArray2, this.alphabet);
    }

    public byte[] decode(byte[] byArray) {
        byte[] byArray2 = this.translate(byArray, this.lookup);
        return this.convert(byArray2, 62, 256);
    }

    private byte[] translate(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = byArray2[byArray[i2]];
        }
        return byArray3;
    }

    private byte[] convert(byte[] byArray, int n2, int n3) {
        int n4 = this.estimateOutputLength(byArray.length, n2, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4);
        byte[] byArray2 = byArray;
        while (byArray2.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(byArray2.length);
            int n5 = 0;
            for (byte by : byArray2) {
                int n6 = (by & 0xFF) + n5 * n2;
                int n7 = (n6 - n6 % n3) / n3;
                n5 = n6 % n3;
                if (byteArrayOutputStream2.size() <= 0 && n7 <= 0) continue;
                byteArrayOutputStream2.write(n7);
            }
            byteArrayOutputStream.write(n5);
            byArray2 = byteArrayOutputStream2.toByteArray();
        }
        for (int i2 = 0; i2 < byArray.length - 1 && byArray[i2] == 0; ++i2) {
            byteArrayOutputStream.write(0);
        }
        return ArrayUtil.reverse(byteArrayOutputStream.toByteArray());
    }

    private int estimateOutputLength(int n2, int n3, int n4) {
        return (int)Math.ceil(Math.log(n3) / Math.log(n4) * (double)n2);
    }
}

