/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.builder;

import com.ccb.core.builder.Builder;
import com.ccb.core.builder.IDKey;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.ArrayUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HashCodeBuilder
implements Builder {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_VALUE = 17;
    private static final int DEFAULT_MULTIPLIER_VALUE = 37;
    private static final ThreadLocal REGISTRY = new ThreadLocal();
    private final int iConstant;
    private int iTotal;

    private static Set getRegistry() {
        return (Set)REGISTRY.get();
    }

    private static boolean isRegistered(Object object) {
        Set set = HashCodeBuilder.getRegistry();
        return set != null && set.contains(new IDKey(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reflectionAppend(Object object, Class clazz, HashCodeBuilder hashCodeBuilder, boolean bl, String[] stringArray) {
        if (HashCodeBuilder.isRegistered(object)) {
            return;
        }
        try {
            HashCodeBuilder.register(object);
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            for (AccessibleObject accessibleObject : accessibleObjectArray) {
                if (ArrayUtil.contains(stringArray, ((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().indexOf(36) != -1 || !bl && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                try {
                    Object object2 = ((Field)accessibleObject).get(object);
                    hashCodeBuilder.append(object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
        }
        finally {
            HashCodeBuilder.unregister(object);
        }
    }

    public static int reflectionHashCode(int n2, int n3, Object object) {
        return HashCodeBuilder.reflectionHashCode(n2, n3, object, false, null, new String[0]);
    }

    public static int reflectionHashCode(int n2, int n3, Object object, boolean bl) {
        return HashCodeBuilder.reflectionHashCode(n2, n3, object, bl, null, new String[0]);
    }

    public static int reflectionHashCode(int n2, int n3, Object object, boolean bl, Class clazz, String ... stringArray) {
        Class<?> clazz2;
        if (object == null) {
            throw new IllegalArgumentException("The object to build a hash code for must not be null");
        }
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(n2, n3);
        HashCodeBuilder.reflectionAppend(object, clazz2, hashCodeBuilder, bl, stringArray);
        for (clazz2 = object.getClass(); clazz2.getSuperclass() != null && clazz2 != clazz; clazz2 = clazz2.getSuperclass()) {
            HashCodeBuilder.reflectionAppend(object, clazz2, hashCodeBuilder, bl, stringArray);
        }
        return hashCodeBuilder.toHashCode();
    }

    public static int reflectionHashCode(Object object, boolean bl) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, bl, null, new String[0]);
    }

    public static int reflectionHashCode(Object object, Collection collection) {
        return HashCodeBuilder.reflectionHashCode(object, (String[])ArrayUtil.toArray(collection, String.class));
    }

    public static int reflectionHashCode(Object object, String ... stringArray) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, false, null, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Object object) {
        Class<HashCodeBuilder> clazz = HashCodeBuilder.class;
        synchronized (HashCodeBuilder.class) {
            if (HashCodeBuilder.getRegistry() == null) {
                REGISTRY.set(new HashSet());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            HashCodeBuilder.getRegistry().add(new IDKey(object));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void unregister(Object object) {
        Set set = HashCodeBuilder.getRegistry();
        if (set == null) return;
        set.remove(new IDKey(object));
        Class<HashCodeBuilder> clazz = HashCodeBuilder.class;
        synchronized (HashCodeBuilder.class) {
            set = HashCodeBuilder.getRegistry();
            if (set == null || !set.isEmpty()) return;
            REGISTRY.remove();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public HashCodeBuilder() {
        this.iConstant = 37;
        this.iTotal = 17;
    }

    public HashCodeBuilder(int n2, int n3) {
        Assert.isTrue(n2 % 2 != 0, "HashCodeBuilder requires an odd initial value", new Object[0]);
        Assert.isTrue(n3 % 2 != 0, "HashCodeBuilder requires an odd multiplier", new Object[0]);
        this.iConstant = n3;
        this.iTotal = n2;
    }

    public HashCodeBuilder append(boolean bl) {
        this.iTotal = this.iTotal * this.iConstant + (bl ? 0 : 1);
        return this;
    }

    public HashCodeBuilder append(boolean[] blArray) {
        if (blArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (boolean bl : blArray) {
                this.append(bl);
            }
        }
        return this;
    }

    public HashCodeBuilder append(byte by) {
        this.iTotal = this.iTotal * this.iConstant + by;
        return this;
    }

    public HashCodeBuilder append(byte[] byArray) {
        if (byArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (byte by : byArray) {
                this.append(by);
            }
        }
        return this;
    }

    public HashCodeBuilder append(char c2) {
        this.iTotal = this.iTotal * this.iConstant + c2;
        return this;
    }

    public HashCodeBuilder append(char[] cArray) {
        if (cArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (char c2 : cArray) {
                this.append(c2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(double d2) {
        return this.append(Double.doubleToLongBits(d2));
    }

    public HashCodeBuilder append(double[] dArray) {
        if (dArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (double d2 : dArray) {
                this.append(d2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(float f2) {
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits(f2);
        return this;
    }

    public HashCodeBuilder append(float[] fArray) {
        if (fArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (float f2 : fArray) {
                this.append(f2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(int n2) {
        this.iTotal = this.iTotal * this.iConstant + n2;
        return this;
    }

    public HashCodeBuilder append(int[] nArray) {
        if (nArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (int n2 : nArray) {
                this.append(n2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(long l2) {
        this.iTotal = this.iTotal * this.iConstant + (int)(l2 ^ l2 >> 32);
        return this;
    }

    public HashCodeBuilder append(long[] lArray) {
        if (lArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (long l2 : lArray) {
                this.append(l2);
            }
        }
        return this;
    }

    public HashCodeBuilder append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
        } else if (object.getClass().isArray()) {
            if (object instanceof long[]) {
                this.append((long[])object);
            } else if (object instanceof int[]) {
                this.append((int[])object);
            } else if (object instanceof short[]) {
                this.append((short[])object);
            } else if (object instanceof char[]) {
                this.append((char[])object);
            } else if (object instanceof byte[]) {
                this.append((byte[])object);
            } else if (object instanceof double[]) {
                this.append((double[])object);
            } else if (object instanceof float[]) {
                this.append((float[])object);
            } else if (object instanceof boolean[]) {
                this.append((boolean[])object);
            } else {
                this.append((Object[])object);
            }
        } else {
            this.iTotal = this.iTotal * this.iConstant + object.hashCode();
        }
        return this;
    }

    public HashCodeBuilder append(Object[] objectArray) {
        if (objectArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (Object object : objectArray) {
                this.append(object);
            }
        }
        return this;
    }

    public HashCodeBuilder append(short s2) {
        this.iTotal = this.iTotal * this.iConstant + s2;
        return this;
    }

    public HashCodeBuilder append(short[] sArray) {
        if (sArray == null) {
            this.iTotal *= this.iConstant;
        } else {
            for (short s2 : sArray) {
                this.append(s2);
            }
        }
        return this;
    }

    public HashCodeBuilder appendSuper(int n2) {
        this.iTotal = this.iTotal * this.iConstant + n2;
        return this;
    }

    public int toHashCode() {
        return this.iTotal;
    }

    @Override
    public Integer build() {
        return this.toHashCode();
    }

    public int hashCode() {
        return this.toHashCode();
    }
}

