/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.annotation;

import com.ccb.core.collection.CollUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CombinationAnnotationElement
implements Serializable,
AnnotatedElement {
    private static final long serialVersionUID = 1L;
    private static final Set META_ANNOTATIONS = CollUtil.newHashSet(Target.class, Retention.class, Inherited.class, Documented.class, SuppressWarnings.class, Override.class, Deprecated.class);
    private Map annotationMap;
    private Map declaredAnnotationMap;

    public CombinationAnnotationElement(AnnotatedElement annotatedElement) {
        this.init(annotatedElement);
    }

    public boolean isAnnotationPresent(Class clazz) {
        return this.annotationMap.containsKey(clazz);
    }

    public Annotation getAnnotation(Class clazz) {
        Annotation annotation = (Annotation)this.annotationMap.get(clazz);
        return annotation == null ? null : annotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        Collection collection = this.annotationMap.values();
        return collection.toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Collection collection = this.declaredAnnotationMap.values();
        return collection.toArray(new Annotation[0]);
    }

    private void init(AnnotatedElement annotatedElement) {
        Object[] objectArray = annotatedElement.getDeclaredAnnotations();
        this.declaredAnnotationMap = new HashMap();
        this.parseDeclared((Annotation[])objectArray);
        Object[] objectArray2 = annotatedElement.getAnnotations();
        if (Arrays.equals(objectArray, objectArray2)) {
            this.annotationMap = this.declaredAnnotationMap;
        } else {
            this.annotationMap = new HashMap();
            this.parse((Annotation[])objectArray2);
        }
    }

    private void parseDeclared(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (META_ANNOTATIONS.contains(clazz)) continue;
            this.declaredAnnotationMap.put(clazz, annotation);
            this.parseDeclared(clazz.getDeclaredAnnotations());
        }
    }

    private void parse(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (META_ANNOTATIONS.contains(clazz)) continue;
            this.annotationMap.put(clazz, annotation);
            this.parse(clazz.getAnnotations());
        }
    }
}

