/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.annotation;

import com.ccb.core.annotation.CombinationAnnotationElement;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationUtil {
    public static CombinationAnnotationElement toCombination(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof CombinationAnnotationElement) {
            return (CombinationAnnotationElement)annotatedElement;
        }
        return new CombinationAnnotationElement(annotatedElement);
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotatedElement, boolean bl) {
        return null == annotatedElement ? null : (bl ? AnnotationUtil.toCombination(annotatedElement) : annotatedElement).getAnnotations();
    }

    public static Annotation getAnnotation(AnnotatedElement annotatedElement, Class clazz) {
        return null == annotatedElement ? null : AnnotationUtil.toCombination(annotatedElement).getAnnotation(clazz);
    }

    public static boolean hasAnnotation(AnnotatedElement annotatedElement, Class clazz) {
        return null != AnnotationUtil.getAnnotation(annotatedElement, clazz);
    }

    public static Object getAnnotationValue(AnnotatedElement annotatedElement, Class clazz) {
        return AnnotationUtil.getAnnotationValue(annotatedElement, clazz, "value");
    }

    public static Object getAnnotationValue(AnnotatedElement annotatedElement, Class clazz, String string) {
        Annotation annotation = AnnotationUtil.getAnnotation(annotatedElement, clazz);
        if (null == annotation) {
            return null;
        }
        Method method = ReflectUtil.getMethodOfObj(annotation, string, new Object[0]);
        if (null == method) {
            return null;
        }
        return ReflectUtil.invoke((Object)annotation, method, new Object[0]);
    }

    public static Map getAnnotationValueMap(AnnotatedElement annotatedElement, Class clazz) {
        Annotation annotation = AnnotationUtil.getAnnotation(annotatedElement, clazz);
        if (null == annotation) {
            return null;
        }
        Method[] methodArray = ReflectUtil.getMethods(clazz, method -> {
            if (ArrayUtil.isEmpty(method.getParameterTypes())) {
                String string = method.getName();
                return false == "hashCode".equals(string) && false == "toString".equals(string) && false == "annotationType".equals(string);
            }
            return false;
        });
        HashMap<String, Object> hashMap = new HashMap<String, Object>(methodArray.length, 1.0f);
        for (Method method2 : methodArray) {
            hashMap.put(method2.getName(), ReflectUtil.invoke((Object)annotation, method2, new Object[0]));
        }
        return hashMap;
    }

    public static RetentionPolicy getRetentionPolicy(Class clazz) {
        Retention retention = clazz.getAnnotation(Retention.class);
        if (null == retention) {
            return RetentionPolicy.CLASS;
        }
        return retention.value();
    }

    public static ElementType[] getTargetType(Class clazz) {
        Target target = clazz.getAnnotation(Target.class);
        if (null == target) {
            return new ElementType[]{ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE, ElementType.ANNOTATION_TYPE, ElementType.PACKAGE};
        }
        return target.value();
    }

    public static boolean isDocumented(Class clazz) {
        return clazz.isAnnotationPresent(Documented.class);
    }

    public static boolean isInherited(Class clazz) {
        return clazz.isAnnotationPresent(Inherited.class);
    }
}

