/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.io.File;
import java.io.IOException;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MappedFile;
import org.apache.rocketmq.store.config.BrokerRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocateMappedFileService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static int waitTimeOut = 5000;
    private ConcurrentHashMap<String, AllocateRequest> requestTable = new ConcurrentHashMap();
    private PriorityBlockingQueue<AllocateRequest> requestQueue = new PriorityBlockingQueue();
    private volatile boolean hasException = false;
    private DefaultMessageStore messageStore;

    public AllocateMappedFileService(DefaultMessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MappedFile putRequestAndReturnMappedFile(String nextFilePath, String nextNextFilePath, int fileSize) {
        AllocateRequest nextNextReq;
        boolean nextNextPutOK;
        AllocateRequest nextReq;
        boolean nextPutOK;
        int canSubmitRequests = 2;
        if (this.messageStore.getMessageStoreConfig().isTransientStorePoolEnable() && this.messageStore.getMessageStoreConfig().isFastFailIfNoBufferInStorePool() && BrokerRole.SLAVE != this.messageStore.getMessageStoreConfig().getBrokerRole()) {
            canSubmitRequests = this.messageStore.getTransientStorePool().remainBufferNumbs() - this.requestQueue.size();
        }
        boolean bl = nextPutOK = this.requestTable.putIfAbsent(nextFilePath, nextReq = new AllocateRequest(nextFilePath, fileSize)) == null;
        if (nextPutOK) {
            if (canSubmitRequests <= 0) {
                log.warn("[NOTIFYME]TransientStorePool is not enough, so create mapped file error, RequestQueueSize : {}, StorePoolSize: {}", (Object)this.requestQueue.size(), (Object)this.messageStore.getTransientStorePool().remainBufferNumbs());
                this.requestTable.remove(nextFilePath);
                return null;
            }
            boolean offerOK = this.requestQueue.offer(nextReq);
            if (!offerOK) {
                log.warn("never expected here, add a request to preallocate queue failed");
            }
            --canSubmitRequests;
        }
        boolean bl2 = nextNextPutOK = this.requestTable.putIfAbsent(nextNextFilePath, nextNextReq = new AllocateRequest(nextNextFilePath, fileSize)) == null;
        if (nextNextPutOK) {
            if (canSubmitRequests <= 0) {
                log.warn("[NOTIFYME]TransientStorePool is not enough, so skip preallocate mapped file, RequestQueueSize : {}, StorePoolSize: {}", (Object)this.requestQueue.size(), (Object)this.messageStore.getTransientStorePool().remainBufferNumbs());
                this.requestTable.remove(nextNextFilePath);
            } else {
                boolean offerOK = this.requestQueue.offer(nextNextReq);
                if (!offerOK) {
                    log.warn("never expected here, add a request to preallocate queue failed");
                }
            }
        }
        if (this.hasException) {
            log.warn(this.getServiceName() + " service has exception. so return null");
            return null;
        }
        AllocateRequest result = this.requestTable.get(nextFilePath);
        try {
            if (result != null) {
                boolean waitOK = result.getCountDownLatch().await(waitTimeOut, TimeUnit.MILLISECONDS);
                if (!waitOK) {
                    log.warn("create mmap timeout " + result.getFilePath() + " " + result.getFileSize());
                    return null;
                }
                this.requestTable.remove(nextFilePath);
                return result.getMappedFile();
            }
            log.error("find preallocate mmap failed, this never happen");
        }
        catch (InterruptedException e) {
            log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
        }
        return null;
    }

    public String getServiceName() {
        return AllocateMappedFileService.class.getSimpleName();
    }

    public void shutdown() {
        this.stopped = true;
        this.thread.interrupt();
        try {
            this.thread.join(this.getJointime());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (AllocateRequest req : this.requestTable.values()) {
            if (req.mappedFile == null) continue;
            log.info("delete pre allocated maped file, {}", (Object)req.mappedFile.getFileName());
            req.mappedFile.destroy(1000L);
        }
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStopped() && this.mmapOperation()) {
        }
        log.info(this.getServiceName() + " service end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mmapOperation() {
        boolean isSuccess = false;
        AllocateRequest req = null;
        try {
            req = this.requestQueue.take();
            AllocateRequest expectedRequest = this.requestTable.get(req.getFilePath());
            if (null == expectedRequest) {
                log.warn("this mmap request expired, maybe cause timeout " + req.getFilePath() + " " + req.getFileSize());
                boolean bl = true;
                return bl;
            }
            if (expectedRequest != req) {
                log.warn("never expected here,  maybe cause timeout " + req.getFilePath() + " " + req.getFileSize() + ", req:" + req + ", expectedRequest:" + expectedRequest);
                boolean bl = true;
                return bl;
            }
            if (req.getMappedFile() == null) {
                long eclipseTime;
                MappedFile mappedFile;
                long beginTime = System.currentTimeMillis();
                if (this.messageStore.getMessageStoreConfig().isTransientStorePoolEnable()) {
                    try {
                        mappedFile = ServiceLoader.load(MappedFile.class).iterator().next();
                        mappedFile.init(req.getFilePath(), req.getFileSize(), this.messageStore.getTransientStorePool());
                    }
                    catch (RuntimeException e) {
                        log.warn("Use default implementation.");
                        mappedFile = new MappedFile(req.getFilePath(), req.getFileSize(), this.messageStore.getTransientStorePool());
                    }
                } else {
                    mappedFile = new MappedFile(req.getFilePath(), req.getFileSize());
                }
                if ((eclipseTime = UtilAll.computeEclipseTimeMilliseconds((long)beginTime)) > 10L) {
                    int queueSize = this.requestQueue.size();
                    log.warn("create mappedFile spent time(ms) " + eclipseTime + " queue size " + queueSize + " " + req.getFilePath() + " " + req.getFileSize());
                }
                if (mappedFile.getFileSize() >= this.messageStore.getMessageStoreConfig().getMapedFileSizeCommitLog() && this.messageStore.getMessageStoreConfig().isWarmMapedFileEnable()) {
                    mappedFile.warmMappedFile(this.messageStore.getMessageStoreConfig().getFlushDiskType(), this.messageStore.getMessageStoreConfig().getFlushLeastPagesWhenWarmMapedFile());
                }
                req.setMappedFile(mappedFile);
                this.hasException = false;
                isSuccess = true;
            }
        }
        catch (InterruptedException e) {
            log.warn(this.getServiceName() + " interrupted, possibly by shutdown.");
            this.hasException = true;
            boolean beginTime = false;
            return beginTime;
        }
        catch (IOException e) {
            log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            this.hasException = true;
            if (null != req) {
                this.requestQueue.offer(req);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
        }
        finally {
            if (req != null && isSuccess) {
                req.getCountDownLatch().countDown();
            }
        }
        return true;
    }

    static class AllocateRequest
    implements Comparable<AllocateRequest> {
        private String filePath;
        private int fileSize;
        private CountDownLatch countDownLatch = new CountDownLatch(1);
        private volatile MappedFile mappedFile = null;

        public AllocateRequest(String filePath, int fileSize) {
            this.filePath = filePath;
            this.fileSize = fileSize;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(int fileSize) {
            this.fileSize = fileSize;
        }

        public CountDownLatch getCountDownLatch() {
            return this.countDownLatch;
        }

        public void setCountDownLatch(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public MappedFile getMappedFile() {
            return this.mappedFile;
        }

        public void setMappedFile(MappedFile mappedFile) {
            this.mappedFile = mappedFile;
        }

        @Override
        public int compareTo(AllocateRequest other) {
            int oIndex;
            long oName;
            if (this.fileSize < other.fileSize) {
                return 1;
            }
            if (this.fileSize > other.fileSize) {
                return -1;
            }
            int mIndex = this.filePath.lastIndexOf(File.separator);
            long mName = Long.parseLong(this.filePath.substring(mIndex + 1));
            if (mName < (oName = Long.parseLong(other.filePath.substring((oIndex = other.filePath.lastIndexOf(File.separator)) + 1)))) {
                return -1;
            }
            if (mName > oName) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
            result = 31 * result + this.fileSize;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AllocateRequest other = (AllocateRequest)obj;
            if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
                return false;
            }
            return this.fileSize == other.fileSize;
        }
    }
}

