/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.vss.commands.edit;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.vss.commands.VssCommandLineUtils;
import org.apache.maven.scm.provider.vss.commands.changelog.VssHistoryCommand;
import org.apache.maven.scm.provider.vss.commands.edit.VssEditConsumer;
import org.apache.maven.scm.provider.vss.repository.VssScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class VssEditCommand
extends AbstractEditCommand {
    protected ScmResult executeEditCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        int exitCode;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing checkout command...");
        }
        VssScmProviderRepository repo = (VssScmProviderRepository)repository;
        Commandline cl = this.buildCmdLine(repo, fileSet);
        VssEditConsumer consumer = new VssEditConsumer(repo, this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
        }
        if ((exitCode = VssCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger())) != 0) {
            String error = stderr.getOutput();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("VSS returns error: [" + error + "] return code: [" + exitCode + "]");
            }
            if (error.indexOf("A writable copy of") < 0) {
                return new EditScmResult(cl.toString(), "The vss command failed.", error, false);
            }
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(error);
            }
        }
        return new EditScmResult(cl.toString(), consumer.getUpdatedFiles());
    }

    public Commandline buildCmdLine(VssScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        try {
            command.addSystemEnvironment();
        }
        catch (Exception e) {
            throw new ScmException("Can't add system environment.", (Throwable)e);
        }
        command.addEnvironment("SSDIR", repo.getVssdir());
        String ssDir = VssCommandLineUtils.getSsDir();
        command.setExecutable(ssDir + "ss");
        command.createArg().setValue("Checkout");
        command.createArg().setValue("$" + repo.getProject());
        if (repo.getUserPassword() != null) {
            command.createArg().setValue("-Y" + repo.getUserPassword());
        }
        command.createArg().setValue("-R");
        command.createArg().setValue("-I-");
        return command;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        VssHistoryCommand command = new VssHistoryCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

