/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.remoteinfo;

import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.remoteinfo.AbstractRemoteInfoCommand;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.remoteinfo.GitRemoteInfoConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitRemoteInfoCommand
extends AbstractRemoteInfoCommand
implements GitCommand {
    public RemoteInfoScmResult executeRemoteInfoCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitRemoteInfoConsumer consumer;
        GitScmProviderRepository gitRepository = (GitScmProviderRepository)repository;
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline clLsRemote = GitRemoteInfoCommand.createCommandLine(gitRepository);
        int exitCode = GitCommandLineUtils.execute(clLsRemote, consumer = new GitRemoteInfoConsumer(this.getLogger(), clLsRemote.toString()), stderr, this.getLogger());
        if (exitCode != 0) {
            throw new ScmException("unbale to execute ls-remote on " + gitRepository.getFetchUrl());
        }
        return consumer.getRemoteInfoScmResult();
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(null, "ls-remote");
        cl.setWorkingDirectory(System.getProperty("java.io.tmpdir"));
        String remoteUrl = repository.getPushUrl();
        cl.createArg().setValue(remoteUrl);
        return cl;
    }
}

