/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsXmlResourceTransformer
implements ResourceTransformer {
    private Map<String, Xpp3Dom> components = new LinkedHashMap<String, Xpp3Dom>();
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    @Override
    public boolean canTransformResource(String resource) {
        return COMPONENTS_XML_PATH.equals(resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        Xpp3Dom newDom;
        try {
            BufferedInputStream bis = new BufferedInputStream(is){

                public void close() throws IOException {
                }
            };
            XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)bis);
            newDom = Xpp3DomBuilder.build((Reader)reader);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error parsing components.xml in " + is).initCause(e);
        }
        if (newDom.getChild("components") == null) {
            return;
        }
        Xpp3Dom[] children = newDom.getChild("components").getChildren("component");
        for (int i = 0; i < children.length; ++i) {
            Xpp3Dom requirements;
            Xpp3Dom dom;
            Xpp3Dom component = children[i];
            String role = ComponentsXmlResourceTransformer.getValue(component, "role");
            role = this.getRelocatedClass(role, relocators);
            ComponentsXmlResourceTransformer.setValue(component, "role", role);
            String roleHint = ComponentsXmlResourceTransformer.getValue(component, "role-hint");
            String impl = ComponentsXmlResourceTransformer.getValue(component, "implementation");
            impl = this.getRelocatedClass(impl, relocators);
            ComponentsXmlResourceTransformer.setValue(component, "implementation", impl);
            String key = role + ':' + roleHint;
            if (this.components.containsKey(key) && (dom = this.components.get(key)).getChild("configuration") != null) {
                component.addChild(dom.getChild("configuration"));
            }
            if ((requirements = component.getChild("requirements")) != null && requirements.getChildCount() > 0) {
                for (int r = requirements.getChildCount() - 1; r >= 0; --r) {
                    Xpp3Dom requirement = requirements.getChild(r);
                    String requiredRole = ComponentsXmlResourceTransformer.getValue(requirement, "role");
                    requiredRole = this.getRelocatedClass(requiredRole, relocators);
                    ComponentsXmlResourceTransformer.setValue(requirement, "role", requiredRole);
                }
            }
            this.components.put(key, component);
        }
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        byte[] data = this.getTransformedResource();
        jos.putNextEntry(new JarEntry(COMPONENTS_XML_PATH));
        IOUtil.copy((byte[])data, (OutputStream)jos);
        this.components.clear();
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.components.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getTransformedResource() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        XmlStreamWriter writer = WriterFactory.newXmlWriter((OutputStream)baos);
        try {
            Xpp3Dom dom = new Xpp3Dom("component-set");
            Xpp3Dom componentDom = new Xpp3Dom("components");
            dom.addChild(componentDom);
            for (Xpp3Dom component : this.components.values()) {
                componentDom.addChild(component);
            }
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        return baos.toByteArray();
    }

    private String getRelocatedClass(String className, List<Relocator> relocators) {
        if (className != null && className.length() > 0 && relocators != null) {
            for (Relocator relocator : relocators) {
                if (!relocator.canRelocateClass(className)) continue;
                return relocator.relocateClass(className);
            }
        }
        return className;
    }

    private static String getValue(Xpp3Dom dom, String element) {
        Xpp3Dom child = dom.getChild(element);
        return child != null && child.getValue() != null ? child.getValue() : "";
    }

    private static void setValue(Xpp3Dom dom, String element, String value) {
        Xpp3Dom child = dom.getChild(element);
        if (child == null || value == null || value.length() <= 0) {
            return;
        }
        child.setValue(value);
    }
}

