/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.invoker.MetadataUtils;
import org.apache.maven.plugins.invoker.PomUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.repository.RepositoryManager;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="install", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class InstallMojo
extends AbstractMojo {
    @Component
    private ArtifactInstaller installer;
    @Component
    private RepositoryManager repositoryManager;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="invoker.localRepositoryPath", defaultValue="${session.localRepository.basedir}", required=true)
    private File localRepositoryPath;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private Collection<MavenProject> reactorProjects;
    @Parameter(property="invoker.skip", defaultValue="false")
    private boolean skipInstallation;
    private Collection<String> installedArtifacts;
    private Collection<String> copiedArtifacts;
    @Parameter
    private String[] extraArtifacts;
    @Component
    private DependencyResolver resolver;
    private ProjectBuildingRequest projectBuildingRequest;

    public void execute() throws MojoExecutionException {
        if (this.skipInstallation) {
            this.getLog().info((CharSequence)"Skipping artifact installation per configuration.");
            return;
        }
        this.createTestRepository();
        this.installedArtifacts = new HashSet<String>();
        this.copiedArtifacts = new HashSet<String>();
        this.installProjectDependencies(this.project, this.reactorProjects);
        this.installProjectParents(this.project);
        this.installProjectArtifacts(this.project);
        this.installExtraArtifacts(this.extraArtifacts);
    }

    private void createTestRepository() throws MojoExecutionException {
        if (!this.localRepositoryPath.exists() && !this.localRepositoryPath.mkdirs()) {
            throw new MojoExecutionException("Failed to create directory: " + this.localRepositoryPath);
        }
        this.projectBuildingRequest = this.repositoryManager.setLocalRepositoryBasedir(this.session.getProjectBuildingRequest(), this.localRepositoryPath);
    }

    private void installArtifact(File file, Artifact artifact) throws MojoExecutionException {
        try {
            if (file == null) {
                throw new IllegalStateException("Artifact has no associated file: " + artifact.getId());
            }
            if (!file.isFile()) {
                throw new IllegalStateException("Artifact is not fully assembled: " + file);
            }
            if (this.installedArtifacts.add(artifact.getId())) {
                artifact.setFile(file);
                this.installer.install(this.projectBuildingRequest, this.localRepositoryPath, Collections.singletonList(artifact));
            } else {
                this.getLog().debug((CharSequence)("Not re-installing " + artifact + ", " + file));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install artifact: " + artifact, e);
        }
    }

    private void copyArtifact(File file, Artifact artifact) throws MojoExecutionException {
        try {
            if (file == null) {
                throw new IllegalStateException("Artifact has no associated file: " + artifact.getId());
            }
            if (!file.isFile()) {
                throw new IllegalStateException("Artifact is not fully assembled: " + file);
            }
            if (this.copiedArtifacts.add(artifact.getId())) {
                File destination = new File(this.localRepositoryPath, this.repositoryManager.getPathForLocalArtifact(this.projectBuildingRequest, artifact));
                this.getLog().debug((CharSequence)("Installing " + file + " to " + destination));
                this.copyFileIfDifferent(file, destination);
                MetadataUtils.createMetadata(destination, artifact);
            } else {
                this.getLog().debug((CharSequence)("Not re-installing " + artifact + ", " + file));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to stage artifact: " + artifact, e);
        }
    }

    private void copyFileIfDifferent(File src, File dst) throws IOException {
        if (src.lastModified() != dst.lastModified() || src.length() != dst.length()) {
            FileUtils.copyFile((File)src, (File)dst);
            dst.setLastModified(src.lastModified());
        }
    }

    private void installProjectArtifacts(MavenProject mvnProject) throws MojoExecutionException {
        try {
            this.installProjectPom(mvnProject);
            Artifact mainArtifact = mvnProject.getArtifact();
            if (mainArtifact.getFile() != null) {
                this.installArtifact(mainArtifact.getFile(), mainArtifact);
            }
            List attachedArtifacts = mvnProject.getAttachedArtifacts();
            for (Artifact attachedArtifact : attachedArtifacts) {
                this.installArtifact(attachedArtifact.getFile(), attachedArtifact);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project artifacts: " + mvnProject, e);
        }
    }

    private void installProjectParents(MavenProject mvnProject) throws MojoExecutionException {
        try {
            for (MavenProject parent = mvnProject.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getFile() == null) {
                    this.copyParentPoms(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                    break;
                }
                this.installProjectPom(parent);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project parents: " + mvnProject, e);
        }
    }

    private void installProjectPom(MavenProject mvnProject) throws MojoExecutionException {
        try {
            Artifact pomArtifact = null;
            if ("pom".equals(mvnProject.getPackaging())) {
                pomArtifact = mvnProject.getArtifact();
            }
            if (pomArtifact == null) {
                pomArtifact = this.artifactFactory.createProjectArtifact(mvnProject.getGroupId(), mvnProject.getArtifactId(), mvnProject.getVersion());
            }
            this.installArtifact(mvnProject.getFile(), pomArtifact);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install POM: " + mvnProject, e);
        }
    }

    private void installProjectDependencies(MavenProject mvnProject, Collection<MavenProject> reactorProjects) throws MojoExecutionException {
        boolean foundCurrent = false;
        LinkedHashSet dependencyProjects = new LinkedHashSet();
        HashMap projects = new HashMap(reactorProjects.size());
        for (MavenProject reactorProject : reactorProjects) {
            Iterator projectId = reactorProject.getGroupId() + ':' + reactorProject.getArtifactId() + ':' + reactorProject.getVersion();
            projects.put(projectId, reactorProject);
            if (!this.isInProjectReferences(this.project.getProjectReferences().values(), reactorProject)) continue;
            dependencyProjects.add(projectId);
        }
        Set artifacts = mvnProject.getArtifacts();
        LinkedHashSet<Artifact> dependencyArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            artifact.isSnapshot();
            String projectId = artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion();
            if (projects.containsKey(projectId)) continue;
            dependencyArtifacts.add(artifact);
        }
        try {
            for (Artifact artifact : dependencyArtifacts) {
                this.copyArtifact(artifact);
            }
            for (String string : dependencyProjects) {
                MavenProject dependencyProject = (MavenProject)projects.get(string);
                this.installProjectArtifacts(dependencyProject);
                this.installProjectParents(dependencyProject);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to install project dependencies: " + mvnProject, e);
        }
    }

    protected boolean isInProjectReferences(Collection<MavenProject> references, MavenProject project) {
        if (references == null || references.isEmpty()) {
            return false;
        }
        for (MavenProject mavenProject : references) {
            if (!StringUtils.equals((String)mavenProject.getId(), (String)project.getId())) continue;
            return true;
        }
        return false;
    }

    private void copyArtifact(Artifact artifact) throws MojoExecutionException {
        this.copyPoms(artifact);
        Artifact depArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier());
        File artifactFile = artifact.getFile();
        this.copyArtifact(artifactFile, depArtifact);
    }

    private void copyPoms(Artifact artifact) throws MojoExecutionException {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
        File pomFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(pomArtifact));
        if (pomFile.isFile()) {
            this.copyArtifact(pomFile, pomArtifact);
            this.copyParentPoms(pomFile);
        }
    }

    private void copyParentPoms(File pomFile) throws MojoExecutionException {
        Model model = PomUtils.loadPom(pomFile);
        Parent parent = model.getParent();
        if (parent != null) {
            this.copyParentPoms(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }
    }

    private void copyParentPoms(String groupId, String artifactId, String version) throws MojoExecutionException {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, version);
        if (this.installedArtifacts.contains(pomArtifact.getId()) || this.copiedArtifacts.contains(pomArtifact.getId())) {
            this.getLog().debug((CharSequence)("Not re-installing " + pomArtifact));
            return;
        }
        File pomFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(pomArtifact));
        if (pomFile.isFile()) {
            this.copyArtifact(pomFile, pomArtifact);
            this.copyParentPoms(pomFile);
        }
    }

    private void installExtraArtifacts(String[] extraArtifacts) throws MojoExecutionException {
        if (extraArtifacts == null) {
            return;
        }
        for (String extraArtifact : extraArtifacts) {
            String[] gav = extraArtifact.split(":");
            if (gav.length < 3 || gav.length > 5) {
                throw new MojoExecutionException("Invalid artifact " + extraArtifact);
            }
            String groupId = gav[0];
            String artifactId = gav[1];
            String version = gav[2];
            String type = "jar";
            if (gav.length > 3) {
                type = gav[3];
            }
            String classifier = null;
            if (gav.length == 5) {
                classifier = gav[4];
            }
            DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
            try {
                coordinate.setGroupId(groupId);
                coordinate.setArtifactId(artifactId);
                coordinate.setVersion(version);
                coordinate.setType(type);
                coordinate.setClassifier(classifier);
                this.resolver.resolveDependencies(this.projectBuildingRequest, (DependableCoordinate)coordinate, null);
            }
            catch (DependencyResolverException e) {
                throw new MojoExecutionException("Unable to resolve dependencies for: " + coordinate, (Exception)((Object)e));
            }
        }
    }
}

